/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringToNominal
extends Filter
implements UnsupervisedFilter,
OptionHandler {
    private static final long serialVersionUID = 4864084427902797605L;
    private Range m_AttIndices = new Range("last");

    public String globalInfo() {
        return "Converts a range of string attributes (unspecified number of values) to nominal (set number of values). You should ensure that all string values that will appear are represented in the first batch of the data.";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enableAllAttributes();
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enableAllClasses();
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    @Override
    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        this.m_AttIndices.setUpper(instances.numAttributes() - 1);
        return false;
    }

    @Override
    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.isOutputFormatDefined()) {
            Instance instance2 = (Instance)instance.copy();
            this.push(instance2);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    @Override
    public boolean batchFinished() {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (!this.isOutputFormatDefined()) {
            this.setOutputFormat();
            for (int i = 0; i < this.getInputFormat().numInstances(); ++i) {
                this.push((Instance)this.getInputFormat().instance(i).copy());
            }
        }
        this.flushInput();
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> vector = new Vector<Option>(1);
        vector.addElement(new Option("\tSets the range of attribute indices (default last).", "R", 1, "-R <col>"));
        vector.addElement(new Option("\tInvert the range specified by -R.", "V", 1, "-V <col>"));
        return vector.elements();
    }

    @Override
    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('R', stringArray);
        if (string.length() != 0) {
            this.setAttributeRange(string);
        } else {
            this.setAttributeRange("last");
        }
        String string2 = Utils.getOption('V', stringArray);
        if (string2.length() != 0) {
            this.m_AttIndices.setInvert(true);
        } else {
            this.m_AttIndices.setInvert(false);
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    @Override
    public String[] getOptions() {
        String[] stringArray = new String[this.m_AttIndices.getInvert() ? 7 : 6];
        int n = 0;
        stringArray[n++] = "-R";
        stringArray[n++] = "" + this.getAttributeRange();
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        if (this.m_AttIndices.getInvert()) {
            stringArray[n++] = "-V";
        }
        return stringArray;
    }

    public String attributeRangeTipText() {
        return "Sets which attributes to process. This attributes must be string attributes (\"first\" and \"last\" are valid values as well as ranges and lists)";
    }

    public String getAttributeRange() {
        return this.m_AttIndices.getRanges();
    }

    public void setAttributeRange(String string) {
        this.m_AttIndices.setRanges(string);
    }

    private void setOutputFormat() {
        FastVector fastVector = new FastVector(this.getInputFormat().numAttributes());
        for (int i = 0; i < this.getInputFormat().numAttributes(); ++i) {
            Attribute attribute = this.getInputFormat().attribute(i);
            if (!this.m_AttIndices.isInRange(i) || !attribute.isString()) {
                fastVector.addElement(attribute);
                continue;
            }
            FastVector fastVector2 = new FastVector(attribute.numValues());
            for (int j = 0; j < attribute.numValues(); ++j) {
                fastVector2.addElement(attribute.value(j));
            }
            fastVector.addElement(new Attribute(attribute.name(), fastVector2));
        }
        Instances instances = new Instances(this.getInputFormat().relationName(), fastVector, 0);
        instances.setClassIndex(this.getInputFormat().classIndex());
        this.setOutputFormat(instances);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 4713 $");
    }

    public static void main(String[] stringArray) {
        StringToNominal.runFilter(new StringToNominal(), stringArray);
    }
}

