/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.MultiInstanceCapabilitiesHandler;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RelationalLocator;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.StringLocator;
import weka.core.Tag;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;

public class MultiInstanceToPropositional
extends Filter
implements OptionHandler,
UnsupervisedFilter,
MultiInstanceCapabilitiesHandler {
    private static final long serialVersionUID = -4102847628883002530L;
    protected int m_NumBags;
    protected StringLocator m_BagStringAtts = null;
    protected RelationalLocator m_BagRelAtts = null;
    protected int m_NumInstances;
    public static final int WEIGHTMETHOD_ORIGINAL = 0;
    public static final int WEIGHTMETHOD_1 = 1;
    public static final int WEIGHTMETHOD_INVERSE1 = 2;
    public static final int WEIGHTMETHOD_INVERSE2 = 3;
    public static final Tag[] TAGS_WEIGHTMETHOD = new Tag[]{new Tag(0, "keep the weight to be the same as the original value"), new Tag(1, "1.0"), new Tag(2, "1.0 / Total # of prop. instance in the corresp. bag"), new Tag(3, "Total # of prop. instance / (Total # of bags * Total # of prop. instance in the corresp. bag)")};
    protected int m_WeightMethod = 3;

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tThe type of weight setting for each prop. instance:\n\t0.weight = original single bag weight /Total number of\n\tprop. instance in the corresponding bag;\n\t1.weight = 1.0;\n\t2.weight = 1.0/Total number of prop. instance in the \n\t\tcorresponding bag; \n\t3. weight = Total number of prop. instance / (Total number \n\t\tof bags * Total number of prop. instance in the \n\t\tcorresponding bag). \n\t(default:0)", "A", 1, "-A <num>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('A', stringArray);
        if (string.length() != 0) {
            this.setWeightMethod(new SelectedTag(Integer.parseInt(string), TAGS_WEIGHTMETHOD));
        } else {
            this.setWeightMethod(new SelectedTag(3, TAGS_WEIGHTMETHOD));
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        vector.add("-A");
        vector.add("" + this.m_WeightMethod);
        return vector.toArray(new String[vector.size()]);
    }

    public String weightMethodTipText() {
        return "The method used for weighting the instances.";
    }

    public void setWeightMethod(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_WEIGHTMETHOD) {
            this.m_WeightMethod = selectedTag.getSelectedTag().getID();
        }
    }

    public SelectedTag getWeightMethod() {
        return new SelectedTag(this.m_WeightMethod, TAGS_WEIGHTMETHOD);
    }

    public String globalInfo() {
        return "Converts the multi-instance dataset into single instance dataset so that the Nominalize, Standardize and other type of filters or transformation  can be applied to these data for the further preprocessing.\nNote: the first attribute of the converted dataset is a nominal attribute and refers to the bagId.";
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disableAllAttributes();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enableAllClasses();
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.ONLY_MULTIINSTANCE);
        return capabilities;
    }

    public Capabilities getMultiInstanceCapabilities() {
        Capabilities capabilities = new Capabilities(this);
        capabilities.enableAllAttributes();
        capabilities.disable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enableAllClasses();
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        capabilities.setMinimumNumberInstances(0);
        return capabilities;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        if (instances.attribute(1).type() != 4) {
            throw new Exception("Can only handle relational-valued attribute!");
        }
        super.setInputFormat(instances);
        this.m_NumBags = instances.numInstances();
        this.m_NumInstances = 0;
        for (int i = 0; i < this.m_NumBags; ++i) {
            this.m_NumInstances += instances.instance(i).relationalValue(1).numInstances();
        }
        Attribute attribute = (Attribute)instances.classAttribute().copy();
        Attribute attribute2 = (Attribute)instances.attribute(0).copy();
        Instances instances2 = instances.attribute(1).relation().stringFreeStructure();
        instances2.insertAttributeAt(attribute2, 0);
        instances2.insertAttributeAt(attribute, instances2.numAttributes());
        instances2.setClassIndex(instances2.numAttributes() - 1);
        super.setOutputFormat(instances2.stringFreeStructure());
        this.m_BagStringAtts = new StringLocator(instances.attribute(1).relation().stringFreeStructure());
        this.m_BagRelAtts = new RelationalLocator(instances.attribute(1).relation().stringFreeStructure());
        return true;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        this.convertInstance(instance);
        return true;
    }

    public boolean batchFinished() {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        Instances instances = this.getInputFormat();
        for (int i = 0; i < instances.numInstances(); ++i) {
            this.convertInstance(instances.instance(i));
        }
        this.flushInput();
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    private void convertInstance(Instance instance) {
        Instances instances = instance.relationalValue(1);
        int n = instances.numInstances();
        double d = instance.value(0);
        double d2 = instance.classValue();
        double d3 = 0.0;
        d3 = this.m_WeightMethod == 1 ? 1.0 : (this.m_WeightMethod == 2 ? 1.0 / (double)n : (this.m_WeightMethod == 3 ? (double)this.m_NumInstances / (double)(this.m_NumBags * n) : instance.weight() / (double)n));
        Instances instances2 = this.getOutputFormat().stringFreeStructure();
        for (int i = 0; i < n; ++i) {
            Instance instance2 = new Instance(instances2.numAttributes());
            instance2.setDataset(instances2);
            instance2.setValue(0, d);
            if (!instance.classIsMissing()) {
                instance2.setClassValue(d2);
            }
            for (int j = 1; j < instances2.numAttributes() - 1; ++j) {
                instance2.setValue(j, instances.instance(i).value(j - 1));
            }
            instance2.setWeight(d3);
            StringLocator.copyStringValues(instance2, false, instances, this.m_BagStringAtts, instances2, this.m_OutputStringAtts);
            RelationalLocator.copyRelationalValues(instance2, false, instances, this.m_BagRelAtts, instances2, this.m_OutputRelAtts);
            this.push(instance2);
        }
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.7 $");
    }

    public static void main(String[] stringArray) {
        MultiInstanceToPropositional.runFilter(new MultiInstanceToPropositional(), stringArray);
    }
}

