/*
 * Decompiled with CFR 0.152.
 */
package weka.core.xml;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import org.w3c.dom.Element;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.ProtectedProperties;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.core.Version;
import weka.core.xml.XMLDocument;

public class XMLInstances
extends XMLDocument
implements Serializable {
    private static final long serialVersionUID = 3626821327547416099L;
    public static String FILE_EXTENSION = ".xrff";
    public static final String TAG_DATASET = "dataset";
    public static final String TAG_HEADER = "header";
    public static final String TAG_BODY = "body";
    public static final String TAG_NOTES = "notes";
    public static final String TAG_ATTRIBUTES = "attributes";
    public static final String TAG_ATTRIBUTE = "attribute";
    public static final String TAG_LABELS = "labels";
    public static final String TAG_LABEL = "label";
    public static final String TAG_METADATA = "metadata";
    public static final String TAG_PROPERTY = "property";
    public static final String TAG_INSTANCES = "instances";
    public static final String TAG_INSTANCE = "instance";
    public static final String TAG_VALUE = "value";
    public static final String ATT_VERSION = "version";
    public static final String ATT_TYPE = "type";
    public static final String ATT_FORMAT = "format";
    public static final String ATT_CLASS = "class";
    public static final String ATT_INDEX = "index";
    public static final String ATT_WEIGHT = "weight";
    public static final String ATT_MISSING = "missing";
    public static final String VAL_NUMERIC = "numeric";
    public static final String VAL_DATE = "date";
    public static final String VAL_NOMINAL = "nominal";
    public static final String VAL_STRING = "string";
    public static final String VAL_RELATIONAL = "relational";
    public static final String VAL_NORMAL = "normal";
    public static final String VAL_SPARSE = "sparse";
    public static final String DOCTYPE = "<!DOCTYPE dataset\n[\n   <!ELEMENT dataset (header,body)>\n   <!ATTLIST dataset name CDATA #REQUIRED>\n   <!ATTLIST dataset version CDATA \"" + Version.VERSION + "\">\n" + "\n" + "   <!" + "ELEMENT" + " " + "header" + " (" + "notes" + "?" + "," + "attributes" + ")" + ">\n" + "   <!" + "ELEMENT" + " " + "body" + " (" + "instances" + ")" + ">\n" + "   <!" + "ELEMENT" + " " + "notes" + " " + "ANY" + ">   <!--  comments, information, copyright, etc. -->\n" + "\n" + "   <!" + "ELEMENT" + " " + "attributes" + " (" + "attribute" + "+" + ")" + ">\n" + "   <!" + "ELEMENT" + " " + "attribute" + " (" + "labels" + "?" + "," + "metadata" + "?" + "," + "attributes" + "?" + ")" + ">\n" + "   <!" + "ATTLIST" + " " + "attribute" + " " + "name" + " " + "CDATA" + " " + "#REQUIRED" + ">\n" + "   <!" + "ATTLIST" + " " + "attribute" + " " + "type" + " (" + "numeric" + "|" + "date" + "|" + "nominal" + "|" + "string" + "|" + "relational" + ") " + "#REQUIRED" + ">\n" + "   <!" + "ATTLIST" + " " + "attribute" + " " + "format" + " " + "CDATA" + " " + "#IMPLIED" + ">\n" + "   <!" + "ATTLIST" + " " + "attribute" + " " + "class" + " (" + "yes" + "|" + "no" + ") \"" + "no" + "\"" + ">\n" + "   <!" + "ELEMENT" + " " + "labels" + " (" + "label" + "*" + ")" + ">   <!-- only for type \"nominal\" -->\n" + "   <!" + "ELEMENT" + " " + "label" + " " + "ANY" + ">\n" + "   <!" + "ELEMENT" + " " + "metadata" + " (" + "property" + "*" + ")" + ">\n" + "   <!" + "ELEMENT" + " " + "property" + " " + "ANY" + ">\n" + "   <!" + "ATTLIST" + " " + "property" + " " + "name" + " " + "CDATA" + " " + "#REQUIRED" + ">\n" + "\n" + "   <!" + "ELEMENT" + " " + "instances" + " (" + "instance" + "*" + ")" + ">\n" + "   <!" + "ELEMENT" + " " + "instance" + " (" + "value" + "*" + ")" + ">\n" + "   <!" + "ATTLIST" + " " + "instance" + " " + "type" + " (" + "normal" + "|" + "sparse" + ") \"" + "normal" + "\"" + ">\n" + "   <!" + "ATTLIST" + " " + "instance" + " " + "weight" + " " + "CDATA" + " " + "#IMPLIED" + ">\n" + "   <!" + "ELEMENT" + " " + "value" + " (" + "#PCDATA" + "|" + "instances" + ")" + "*" + ">\n" + "   <!" + "ATTLIST" + " " + "value" + " " + "index" + " " + "CDATA" + " " + "#IMPLIED" + ">   <!-- 1-based index (only used for instance format \"sparse\") -->\n" + "   <!" + "ATTLIST" + " " + "value" + " " + "missing" + " (" + "yes" + "|" + "no" + ") \"" + "no" + "\"" + ">\n" + "]\n" + ">";
    protected int m_Precision = 6;
    protected Instances m_Instances = null;

    public XMLInstances() throws Exception {
        this.setDocType(DOCTYPE);
        this.setRootNode(TAG_DATASET);
        this.setValidating(true);
    }

    public XMLInstances(Instances instances) throws Exception {
        this();
        this.setInstances(instances);
    }

    public XMLInstances(Reader reader) throws Exception {
        this();
        this.setXML(reader);
    }

    protected void addAttribute(Element element, Attribute attribute) {
        String string;
        Enumeration<?> enumeration;
        Element element2;
        Element element3 = this.m_Document.createElement(TAG_ATTRIBUTE);
        element.appendChild(element3);
        element3.setAttribute("name", this.validContent(attribute.name()));
        switch (attribute.type()) {
            case 0: {
                element3.setAttribute(ATT_TYPE, VAL_NUMERIC);
                break;
            }
            case 3: {
                element3.setAttribute(ATT_TYPE, VAL_DATE);
                break;
            }
            case 1: {
                element3.setAttribute(ATT_TYPE, VAL_NOMINAL);
                break;
            }
            case 2: {
                element3.setAttribute(ATT_TYPE, VAL_STRING);
                break;
            }
            case 4: {
                element3.setAttribute(ATT_TYPE, VAL_RELATIONAL);
                break;
            }
            default: {
                element3.setAttribute(ATT_TYPE, "???");
            }
        }
        if (attribute.isNominal()) {
            element2 = this.m_Document.createElement(TAG_LABELS);
            element3.appendChild(element2);
            enumeration = attribute.enumerateValues();
            while (enumeration.hasMoreElements()) {
                string = enumeration.nextElement().toString();
                Element element4 = this.m_Document.createElement(TAG_LABEL);
                element2.appendChild(element4);
                element4.appendChild(this.m_Document.createTextNode(this.validContent(string)));
            }
        }
        if (attribute.isDate()) {
            element3.setAttribute(ATT_FORMAT, this.validContent(attribute.getDateFormat()));
        }
        if (this.m_Instances.classIndex() > -1 && attribute == this.m_Instances.classAttribute()) {
            element3.setAttribute(ATT_CLASS, "yes");
        }
        if (attribute.getMetadata() != null && attribute.getMetadata().size() > 0) {
            element2 = this.m_Document.createElement(TAG_METADATA);
            element3.appendChild(element2);
            enumeration = attribute.getMetadata().propertyNames();
            while (enumeration.hasMoreElements()) {
                string = enumeration.nextElement().toString();
                Element element5 = this.m_Document.createElement(TAG_PROPERTY);
                element2.appendChild(element5);
                element5.setAttribute("name", this.validContent(string));
                element5.appendChild(this.m_Document.createTextNode(this.validContent(attribute.getMetadata().getProperty(string, ""))));
            }
        }
        if (attribute.isRelationValued()) {
            element2 = this.m_Document.createElement(TAG_ATTRIBUTES);
            element3.appendChild(element2);
            for (int i = 0; i < attribute.relation().numAttributes(); ++i) {
                this.addAttribute(element2, attribute.relation().attribute(i));
            }
        }
    }

    protected String validContent(String string) {
        String string2 = string;
        string2 = string2.replaceAll("&", "&amp;").replaceAll("\"", "&quot;").replaceAll("'", "&apos;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        string2 = string2.replaceAll("\n", "&#10;").replaceAll("\r", "&#13;").replaceAll("\t", "&#9;");
        return string2;
    }

    protected void addInstance(Element element, Instance instance) {
        Element element2 = this.m_Document.createElement(TAG_INSTANCE);
        element.appendChild(element2);
        boolean bl = instance instanceof SparseInstance;
        if (bl) {
            element2.setAttribute(ATT_TYPE, VAL_SPARSE);
        }
        if (instance.weight() != 1.0) {
            element2.setAttribute(ATT_WEIGHT, Utils.doubleToString(instance.weight(), this.m_Precision));
        }
        for (int i = 0; i < instance.numValues(); ++i) {
            int n = instance.index(i);
            Element element3 = this.m_Document.createElement(TAG_VALUE);
            element2.appendChild(element3);
            if (instance.isMissing(n)) {
                element3.setAttribute(ATT_MISSING, "yes");
            } else if (instance.attribute(n).isRelationValued()) {
                Element element4 = this.m_Document.createElement(TAG_INSTANCES);
                element3.appendChild(element4);
                for (int j = 0; j < instance.relationalValue(i).numInstances(); ++j) {
                    this.addInstance(element4, instance.relationalValue(i).instance(j));
                }
            } else if (instance.attribute(n).type() == 0) {
                element3.appendChild(this.m_Document.createTextNode(Utils.doubleToString(instance.value(n), this.m_Precision)));
            } else {
                element3.appendChild(this.m_Document.createTextNode(this.validContent(instance.stringValue(n))));
            }
            if (!bl) continue;
            element3.setAttribute(ATT_INDEX, "" + (n + 1));
        }
    }

    protected void headerToXML() {
        Element element = this.m_Document.getDocumentElement();
        element.setAttribute("name", this.validContent(this.m_Instances.relationName()));
        element.setAttribute(ATT_VERSION, Version.VERSION);
        Element element2 = this.m_Document.createElement(TAG_HEADER);
        element.appendChild(element2);
        Element element3 = this.m_Document.createElement(TAG_ATTRIBUTES);
        element2.appendChild(element3);
        for (int i = 0; i < this.m_Instances.numAttributes(); ++i) {
            this.addAttribute(element3, this.m_Instances.attribute(i));
        }
    }

    protected void dataToXML() {
        Element element = this.m_Document.getDocumentElement();
        Element element2 = this.m_Document.createElement(TAG_BODY);
        element.appendChild(element2);
        Element element3 = this.m_Document.createElement(TAG_INSTANCES);
        element2.appendChild(element3);
        for (int i = 0; i < this.m_Instances.numInstances(); ++i) {
            this.addInstance(element3, this.m_Instances.instance(i));
        }
    }

    public void setInstances(Instances instances) {
        this.m_Instances = new Instances(instances);
        this.clear();
        this.headerToXML();
        this.dataToXML();
    }

    public Instances getInstances() {
        return this.m_Instances;
    }

    protected ProtectedProperties createMetadata(Element element) throws Exception {
        ProtectedProperties protectedProperties = null;
        Element element2 = null;
        Vector vector = XMLInstances.getChildTags(element, TAG_METADATA);
        if (vector.size() > 0) {
            element2 = (Element)vector.get(0);
        }
        if (element2 != null) {
            Properties properties = new Properties();
            vector = XMLInstances.getChildTags(element2, TAG_PROPERTY);
            for (int i = 0; i < vector.size(); ++i) {
                Element element3 = (Element)vector.get(i);
                properties.setProperty(element3.getAttribute("name"), XMLInstances.getContent(element3));
            }
            protectedProperties = new ProtectedProperties(properties);
        }
        return protectedProperties;
    }

    protected FastVector createLabels(Element element) throws Exception {
        FastVector fastVector = new FastVector();
        Element element2 = null;
        Vector vector = XMLInstances.getChildTags(element, TAG_LABELS);
        if (vector.size() > 0) {
            element2 = (Element)vector.get(0);
        }
        if (element2 != null) {
            vector = XMLInstances.getChildTags(element2, TAG_LABEL);
            for (int i = 0; i < vector.size(); ++i) {
                Element element3 = (Element)vector.get(i);
                fastVector.addElement(XMLInstances.getContent(element3));
            }
        }
        return fastVector;
    }

    protected Attribute createAttribute(Element element) throws Exception {
        int n;
        Attribute attribute = null;
        String string = element.getAttribute("name");
        String string2 = element.getAttribute(ATT_TYPE);
        if (string2.equals(VAL_NUMERIC)) {
            n = 0;
        } else if (string2.equals(VAL_DATE)) {
            n = 3;
        } else if (string2.equals(VAL_NOMINAL)) {
            n = 1;
        } else if (string2.equals(VAL_STRING)) {
            n = 2;
        } else if (string2.equals(VAL_RELATIONAL)) {
            n = 4;
        } else {
            throw new Exception("Attribute type '" + string2 + "' is not supported!");
        }
        ProtectedProperties protectedProperties = this.createMetadata(element);
        switch (n) {
            case 0: {
                if (protectedProperties == null) {
                    attribute = new Attribute(string);
                    break;
                }
                attribute = new Attribute(string, protectedProperties);
                break;
            }
            case 3: {
                if (protectedProperties == null) {
                    attribute = new Attribute(string, element.getAttribute(ATT_FORMAT));
                    break;
                }
                attribute = new Attribute(string, element.getAttribute(ATT_FORMAT), protectedProperties);
                break;
            }
            case 1: {
                FastVector fastVector = this.createLabels(element);
                if (protectedProperties == null) {
                    attribute = new Attribute(string, fastVector);
                    break;
                }
                attribute = new Attribute(string, fastVector, protectedProperties);
                break;
            }
            case 2: {
                if (protectedProperties == null) {
                    attribute = new Attribute(string, (FastVector)null);
                    break;
                }
                attribute = new Attribute(string, (FastVector)null, protectedProperties);
                break;
            }
            case 4: {
                Vector vector = XMLInstances.getChildTags(element, TAG_ATTRIBUTES);
                element = (Element)vector.get(0);
                FastVector fastVector = this.createAttributes(element, new int[1]);
                attribute = protectedProperties == null ? new Attribute(string, new Instances(string, fastVector, 0)) : new Attribute(string, new Instances(string, fastVector, 0), protectedProperties);
            }
        }
        return attribute;
    }

    protected FastVector createAttributes(Element element, int[] nArray) throws Exception {
        FastVector fastVector = new FastVector();
        nArray[0] = -1;
        Vector vector = XMLInstances.getChildTags(element, TAG_ATTRIBUTE);
        for (int i = 0; i < vector.size(); ++i) {
            Element element2 = (Element)vector.get(i);
            Attribute attribute = this.createAttribute(element2);
            if (element2.getAttribute(ATT_CLASS).equals("yes")) {
                nArray[0] = i;
            }
            fastVector.addElement(attribute);
        }
        return fastVector;
    }

    protected Instance createInstance(Instances instances, Element element) throws Exception {
        Instance instance = null;
        boolean bl = element.getAttribute(ATT_TYPE).equals(VAL_SPARSE);
        double[] dArray = new double[instances.numAttributes()];
        double d = element.getAttribute(ATT_WEIGHT).length() != 0 ? Double.parseDouble(element.getAttribute(ATT_WEIGHT)) : 1.0;
        Vector vector = XMLInstances.getChildTags(element, TAG_VALUE);
        block7: for (int i = 0; i < vector.size(); ++i) {
            Element element2 = (Element)vector.get(i);
            int n = bl ? Integer.parseInt(element2.getAttribute(ATT_INDEX)) - 1 : i;
            if (element2.getAttribute(ATT_MISSING).equals("yes")) {
                dArray[n] = Instance.missingValue();
                continue;
            }
            String string = XMLInstances.getContent(element2);
            switch (instances.attribute(n).type()) {
                case 0: {
                    dArray[n] = Double.parseDouble(string);
                    continue block7;
                }
                case 3: {
                    dArray[n] = instances.attribute(n).parseDate(string);
                    continue block7;
                }
                case 1: {
                    dArray[n] = instances.attribute(n).indexOfValue(string);
                    continue block7;
                }
                case 2: {
                    dArray[n] = instances.attribute(n).addStringValue(string);
                    continue block7;
                }
                case 4: {
                    Vector vector2 = XMLInstances.getChildTags(element2, TAG_INSTANCES);
                    Element element3 = (Element)vector2.get(0);
                    Instances instances2 = this.createInstances(instances.attribute(n).relation(), element3);
                    dArray[n] = instances.attribute(n).addRelation(instances2);
                    continue block7;
                }
                default: {
                    throw new Exception("Attribute type " + instances.attribute(n).type() + " is not supported!");
                }
            }
        }
        instance = bl ? new SparseInstance(d, dArray) : new Instance(d, dArray);
        return instance;
    }

    protected Instances createInstances(Instances instances, Element element) throws Exception {
        Instances instances2 = new Instances(instances, 0);
        Vector vector = XMLInstances.getChildTags(element, TAG_INSTANCE);
        for (int i = 0; i < vector.size(); ++i) {
            instances2.add(this.createInstance(instances2, (Element)vector.get(i)));
        }
        return instances2;
    }

    protected Instances headerFromXML() throws Exception {
        Version version2 = new Version();
        Element element = this.m_Document.getDocumentElement();
        if (version2.isOlder(element.getAttribute(ATT_VERSION))) {
            System.out.println("WARNING: loading data of version " + element.getAttribute(ATT_VERSION) + " with version " + Version.VERSION);
        }
        Vector vector = XMLInstances.getChildTags(element, TAG_HEADER);
        Element element2 = (Element)vector.get(0);
        vector = XMLInstances.getChildTags(element2, TAG_ATTRIBUTES);
        element2 = (Element)vector.get(0);
        int[] nArray = new int[1];
        FastVector fastVector = this.createAttributes(element2, nArray);
        Instances instances = new Instances(element.getAttribute("name"), fastVector, 0);
        instances.setClassIndex(nArray[0]);
        return instances;
    }

    protected Instances dataFromXML(Instances instances) throws Exception {
        Vector vector = XMLInstances.getChildTags(this.m_Document.getDocumentElement(), TAG_BODY);
        Element element = (Element)vector.get(0);
        vector = XMLInstances.getChildTags(element, TAG_INSTANCES);
        element = (Element)vector.get(0);
        Instances instances2 = this.createInstances(instances, element);
        return instances2;
    }

    public void setXML(Reader reader) throws Exception {
        this.read(reader);
        this.m_Instances = this.dataFromXML(this.headerFromXML());
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.4 $");
    }

    public static void main(String[] stringArray) {
        try {
            BufferedReader bufferedReader = null;
            if (stringArray.length != 1) {
                throw new Exception("Usage: XMLInstances <filename>");
            }
            Object object = new FileInputStream(stringArray[0]);
            if (stringArray[0].endsWith(".gz")) {
                object = new GZIPInputStream((InputStream)object);
            }
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
            if (stringArray[0].endsWith(".arff")) {
                object = new XMLInstances(new Instances(bufferedReader));
                System.out.println(((XMLDocument)object).toString());
            } else {
                object = new XMLInstances(bufferedReader).getInstances();
                System.out.println(((Instances)object).toSummaryString());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

