/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.util.Enumeration;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.UnassignedDatasetException;
import weka.core.Utils;

public class SparseInstance
extends Instance {
    private static final long serialVersionUID = -3579051291332630149L;
    protected int[] m_Indices;
    protected int m_NumAttributes;

    protected SparseInstance() {
    }

    public SparseInstance(Instance instance) {
        this.m_Weight = instance.m_Weight;
        this.m_Dataset = null;
        this.m_NumAttributes = instance.numAttributes();
        if (instance instanceof SparseInstance) {
            this.m_AttValues = ((SparseInstance)instance).m_AttValues;
            this.m_Indices = ((SparseInstance)instance).m_Indices;
        } else {
            double[] dArray = new double[instance.numAttributes()];
            int[] nArray = new int[instance.numAttributes()];
            int n = 0;
            for (int i = 0; i < instance.numAttributes(); ++i) {
                if (instance.value(i) == 0.0) continue;
                dArray[n] = instance.value(i);
                nArray[n] = i;
                ++n;
            }
            this.m_AttValues = new double[n];
            this.m_Indices = new int[n];
            System.arraycopy(dArray, 0, this.m_AttValues, 0, n);
            System.arraycopy(nArray, 0, this.m_Indices, 0, n);
        }
    }

    public SparseInstance(SparseInstance sparseInstance) {
        this.m_AttValues = sparseInstance.m_AttValues;
        this.m_Indices = sparseInstance.m_Indices;
        this.m_Weight = sparseInstance.m_Weight;
        this.m_NumAttributes = sparseInstance.m_NumAttributes;
        this.m_Dataset = null;
    }

    public SparseInstance(double d, double[] dArray) {
        this.m_Weight = d;
        this.m_Dataset = null;
        this.m_NumAttributes = dArray.length;
        double[] dArray2 = new double[this.m_NumAttributes];
        int[] nArray = new int[this.m_NumAttributes];
        int n = 0;
        for (int i = 0; i < this.m_NumAttributes; ++i) {
            if (dArray[i] == 0.0) continue;
            dArray2[n] = dArray[i];
            nArray[n] = i;
            ++n;
        }
        this.m_AttValues = new double[n];
        this.m_Indices = new int[n];
        System.arraycopy(dArray2, 0, this.m_AttValues, 0, n);
        System.arraycopy(nArray, 0, this.m_Indices, 0, n);
    }

    public SparseInstance(double d, double[] dArray, int[] nArray, int n) {
        int n2 = 0;
        this.m_AttValues = new double[dArray.length];
        this.m_Indices = new int[nArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] == 0.0) continue;
            this.m_AttValues[n2] = dArray[i];
            this.m_Indices[n2] = nArray[i];
            ++n2;
        }
        if (n2 != dArray.length) {
            double[] dArray2 = new double[n2];
            System.arraycopy(this.m_AttValues, 0, dArray2, 0, n2);
            this.m_AttValues = dArray2;
            int[] nArray2 = new int[n2];
            System.arraycopy(this.m_Indices, 0, nArray2, 0, n2);
            this.m_Indices = nArray2;
        }
        this.m_Weight = d;
        this.m_NumAttributes = n;
        this.m_Dataset = null;
    }

    public SparseInstance(int n) {
        this.m_AttValues = new double[n];
        this.m_NumAttributes = n;
        this.m_Indices = new int[n];
        for (int i = 0; i < this.m_AttValues.length; ++i) {
            this.m_AttValues[i] = Double.NaN;
            this.m_Indices[i] = i;
        }
        this.m_Weight = 1.0;
        this.m_Dataset = null;
    }

    public Attribute attributeSparse(int n) {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.m_Dataset.attribute(this.m_Indices[n]);
    }

    public Object copy() {
        SparseInstance sparseInstance = new SparseInstance(this);
        sparseInstance.m_Dataset = this.m_Dataset;
        return sparseInstance;
    }

    public int index(int n) {
        return this.m_Indices[n];
    }

    public boolean isMissing(int n) {
        return Double.isNaN(this.value(n));
    }

    public int locateIndex(int n) {
        int n2 = 0;
        int n3 = this.m_Indices.length - 1;
        if (n3 == -1) {
            return -1;
        }
        while (this.m_Indices[n2] <= n && this.m_Indices[n3] >= n) {
            int n4 = (n3 + n2) / 2;
            if (this.m_Indices[n4] > n) {
                n3 = n4 - 1;
                continue;
            }
            if (this.m_Indices[n4] < n) {
                n2 = n4 + 1;
                continue;
            }
            return n4;
        }
        if (this.m_Indices[n3] < n) {
            return n3;
        }
        return n2 - 1;
    }

    public Instance mergeInstance(Instance instance) {
        double[] dArray = new double[this.numValues() + instance.numValues()];
        int[] nArray = new int[this.numValues() + instance.numValues()];
        int n = 0;
        int n2 = 0;
        while (n2 < this.numValues()) {
            dArray[n] = this.valueSparse(n2);
            nArray[n] = this.index(n2);
            ++n2;
            ++n;
        }
        n2 = 0;
        while (n2 < instance.numValues()) {
            dArray[n] = instance.valueSparse(n2);
            nArray[n] = this.numAttributes() + instance.index(n2);
            ++n2;
            ++n;
        }
        return new SparseInstance(1.0, dArray, nArray, this.numAttributes() + instance.numAttributes());
    }

    public int numAttributes() {
        return this.m_NumAttributes;
    }

    public int numValues() {
        return this.m_Indices.length;
    }

    public void replaceMissingValues(double[] dArray) {
        if (dArray == null || dArray.length != this.m_NumAttributes) {
            throw new IllegalArgumentException("Unequal number of attributes!");
        }
        double[] dArray2 = new double[this.m_AttValues.length];
        int[] nArray = new int[this.m_AttValues.length];
        int n = 0;
        for (int i = 0; i < this.m_AttValues.length; ++i) {
            if (SparseInstance.isMissingValue(this.m_AttValues[i])) {
                if (dArray[this.m_Indices[i]] == 0.0) continue;
                dArray2[n] = dArray[this.m_Indices[i]];
                nArray[n] = this.m_Indices[i];
                ++n;
                continue;
            }
            dArray2[n] = this.m_AttValues[i];
            nArray[n] = this.m_Indices[i];
            ++n;
        }
        this.m_AttValues = new double[n];
        this.m_Indices = new int[n];
        System.arraycopy(dArray2, 0, this.m_AttValues, 0, n);
        System.arraycopy(nArray, 0, this.m_Indices, 0, n);
    }

    public void setValue(int n, double d) {
        int n2 = this.locateIndex(n);
        if (n2 >= 0 && this.m_Indices[n2] == n) {
            if (d != 0.0) {
                double[] dArray = new double[this.m_AttValues.length];
                System.arraycopy(this.m_AttValues, 0, dArray, 0, this.m_AttValues.length);
                dArray[n2] = d;
                this.m_AttValues = dArray;
            } else {
                double[] dArray = new double[this.m_AttValues.length - 1];
                int[] nArray = new int[this.m_Indices.length - 1];
                System.arraycopy(this.m_AttValues, 0, dArray, 0, n2);
                System.arraycopy(this.m_Indices, 0, nArray, 0, n2);
                System.arraycopy(this.m_AttValues, n2 + 1, dArray, n2, this.m_AttValues.length - n2 - 1);
                System.arraycopy(this.m_Indices, n2 + 1, nArray, n2, this.m_Indices.length - n2 - 1);
                this.m_AttValues = dArray;
                this.m_Indices = nArray;
            }
        } else if (d != 0.0) {
            double[] dArray = new double[this.m_AttValues.length + 1];
            int[] nArray = new int[this.m_Indices.length + 1];
            System.arraycopy(this.m_AttValues, 0, dArray, 0, n2 + 1);
            System.arraycopy(this.m_Indices, 0, nArray, 0, n2 + 1);
            nArray[n2 + 1] = n;
            dArray[n2 + 1] = d;
            System.arraycopy(this.m_AttValues, n2 + 1, dArray, n2 + 2, this.m_AttValues.length - n2 - 1);
            System.arraycopy(this.m_Indices, n2 + 1, nArray, n2 + 2, this.m_Indices.length - n2 - 1);
            this.m_AttValues = dArray;
            this.m_Indices = nArray;
        }
    }

    public void setValueSparse(int n, double d) {
        if (d != 0.0) {
            double[] dArray = new double[this.m_AttValues.length];
            System.arraycopy(this.m_AttValues, 0, dArray, 0, this.m_AttValues.length);
            this.m_AttValues = dArray;
            this.m_AttValues[n] = d;
        } else {
            double[] dArray = new double[this.m_AttValues.length - 1];
            int[] nArray = new int[this.m_Indices.length - 1];
            System.arraycopy(this.m_AttValues, 0, dArray, 0, n);
            System.arraycopy(this.m_Indices, 0, nArray, 0, n);
            System.arraycopy(this.m_AttValues, n + 1, dArray, n, this.m_AttValues.length - n - 1);
            System.arraycopy(this.m_Indices, n + 1, nArray, n, this.m_Indices.length - n - 1);
            this.m_AttValues = dArray;
            this.m_Indices = nArray;
        }
    }

    public void modifyValue(int n, double d) {
        int n2 = this.locateIndex(n);
        if (n2 >= 0 && this.m_Indices[n2] == n) {
            if (d != 0.0) {
                this.m_AttValues[n2] = d;
            } else {
                double[] dArray = new double[this.m_AttValues.length - 1];
                int[] nArray = new int[this.m_Indices.length - 1];
                System.arraycopy(this.m_AttValues, 0, dArray, 0, n2);
                System.arraycopy(this.m_Indices, 0, nArray, 0, n2);
                System.arraycopy(this.m_AttValues, n2 + 1, dArray, n2, this.m_AttValues.length - n2 - 1);
                System.arraycopy(this.m_Indices, n2 + 1, nArray, n2, this.m_Indices.length - n2 - 1);
                this.m_AttValues = dArray;
                this.m_Indices = nArray;
            }
        } else if (d != 0.0) {
            double[] dArray = new double[this.m_AttValues.length + 1];
            int[] nArray = new int[this.m_Indices.length + 1];
            System.arraycopy(this.m_AttValues, 0, dArray, 0, n2 + 1);
            System.arraycopy(this.m_Indices, 0, nArray, 0, n2 + 1);
            nArray[n2 + 1] = n;
            dArray[n2 + 1] = d;
            System.arraycopy(this.m_AttValues, n2 + 1, dArray, n2 + 2, this.m_AttValues.length - n2 - 1);
            System.arraycopy(this.m_Indices, n2 + 1, nArray, n2 + 2, this.m_Indices.length - n2 - 1);
            this.m_AttValues = dArray;
            this.m_Indices = nArray;
        }
    }

    public double[] toDoubleArray() {
        double[] dArray = new double[this.m_NumAttributes];
        for (int i = 0; i < this.m_AttValues.length; ++i) {
            dArray[this.m_Indices[i]] = this.m_AttValues[i];
        }
        return dArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        for (int i = 0; i < this.m_Indices.length; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            if (SparseInstance.isMissingValue(this.m_AttValues[i])) {
                stringBuffer.append(this.m_Indices[i] + " ?");
                continue;
            }
            if (this.m_Dataset == null) {
                stringBuffer.append(this.m_Indices[i] + " " + Utils.doubleToString(this.m_AttValues[i], 6));
                continue;
            }
            if (this.m_Dataset.attribute(this.m_Indices[i]).isNominal() || this.m_Dataset.attribute(this.m_Indices[i]).isString() || this.m_Dataset.attribute(this.m_Indices[i]).isDate()) {
                try {
                    stringBuffer.append(this.m_Indices[i] + " " + Utils.quote(this.stringValue(this.m_Indices[i])));
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.err.println(new Instances(this.m_Dataset, 0));
                    System.err.println("Att:" + this.m_Indices[i] + " Val:" + this.valueSparse(i));
                    throw new Error("This should never happen!");
                }
            }
            if (this.m_Dataset.attribute(this.m_Indices[i]).isRelationValued()) {
                try {
                    stringBuffer.append(this.m_Indices[i] + " " + Utils.quote(this.m_Dataset.attribute(this.m_Indices[i]).relation((int)this.valueSparse(i)).stringWithoutHeader()));
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.err.println(new Instances(this.m_Dataset, 0));
                    System.err.println("Att:" + this.m_Indices[i] + " Val:" + this.valueSparse(i));
                    throw new Error("This should never happen!");
                }
            }
            stringBuffer.append(this.m_Indices[i] + " " + Utils.doubleToString(this.m_AttValues[i], 6));
        }
        stringBuffer.append('}');
        if (this.m_Weight != 1.0) {
            stringBuffer.append(",{" + Utils.doubleToString(this.m_Weight, 6) + "}");
        }
        return stringBuffer.toString();
    }

    public double value(int n) {
        int n2 = this.locateIndex(n);
        if (n2 >= 0 && this.m_Indices[n2] == n) {
            return this.m_AttValues[n2];
        }
        return 0.0;
    }

    void forceDeleteAttributeAt(int n) {
        int n2 = this.locateIndex(n);
        --this.m_NumAttributes;
        if (n2 >= 0 && this.m_Indices[n2] == n) {
            int[] nArray = new int[this.m_Indices.length - 1];
            double[] dArray = new double[this.m_AttValues.length - 1];
            System.arraycopy(this.m_Indices, 0, nArray, 0, n2);
            System.arraycopy(this.m_AttValues, 0, dArray, 0, n2);
            for (int i = n2; i < this.m_Indices.length - 1; ++i) {
                nArray[i] = this.m_Indices[i + 1] - 1;
                dArray[i] = this.m_AttValues[i + 1];
            }
            this.m_Indices = nArray;
            this.m_AttValues = dArray;
        } else {
            int[] nArray = new int[this.m_Indices.length];
            double[] dArray = new double[this.m_AttValues.length];
            System.arraycopy(this.m_Indices, 0, nArray, 0, n2 + 1);
            System.arraycopy(this.m_AttValues, 0, dArray, 0, n2 + 1);
            for (int i = n2 + 1; i < this.m_Indices.length; ++i) {
                nArray[i] = this.m_Indices[i] - 1;
                dArray[i] = this.m_AttValues[i];
            }
            this.m_Indices = nArray;
            this.m_AttValues = dArray;
        }
    }

    void forceInsertAttributeAt(int n) {
        int n2 = this.locateIndex(n);
        ++this.m_NumAttributes;
        if (n2 >= 0 && this.m_Indices[n2] == n) {
            int[] nArray = new int[this.m_Indices.length + 1];
            double[] dArray = new double[this.m_AttValues.length + 1];
            System.arraycopy(this.m_Indices, 0, nArray, 0, n2);
            System.arraycopy(this.m_AttValues, 0, dArray, 0, n2);
            nArray[n2] = n;
            dArray[n2] = Double.NaN;
            for (int i = n2; i < this.m_Indices.length; ++i) {
                nArray[i + 1] = this.m_Indices[i] + 1;
                dArray[i + 1] = this.m_AttValues[i];
            }
            this.m_Indices = nArray;
            this.m_AttValues = dArray;
        } else {
            int[] nArray = new int[this.m_Indices.length + 1];
            double[] dArray = new double[this.m_AttValues.length + 1];
            System.arraycopy(this.m_Indices, 0, nArray, 0, n2 + 1);
            System.arraycopy(this.m_AttValues, 0, dArray, 0, n2 + 1);
            nArray[n2 + 1] = n;
            dArray[n2 + 1] = Double.NaN;
            for (int i = n2 + 1; i < this.m_Indices.length; ++i) {
                nArray[i + 1] = this.m_Indices[i] + 1;
                dArray[i + 1] = this.m_AttValues[i];
            }
            this.m_Indices = nArray;
            this.m_AttValues = dArray;
        }
    }

    public static void main(String[] stringArray) {
        try {
            Object object;
            int n;
            Attribute attribute = new Attribute("length");
            Attribute attribute2 = new Attribute("weight");
            FastVector fastVector = new FastVector(3);
            fastVector.addElement("first");
            fastVector.addElement("second");
            fastVector.addElement("third");
            Attribute attribute3 = new Attribute("position", fastVector);
            FastVector fastVector2 = new FastVector(3);
            fastVector2.addElement(attribute);
            fastVector2.addElement(attribute2);
            fastVector2.addElement(attribute3);
            Instances instances = new Instances("race", fastVector2, 0);
            instances.setClassIndex(attribute3.index());
            SparseInstance sparseInstance = new SparseInstance(3);
            sparseInstance.setValue(attribute, 5.3);
            sparseInstance.setValue(attribute2, 300.0);
            sparseInstance.setValue(attribute3, "first");
            sparseInstance.setDataset(instances);
            System.out.println("The instance: " + sparseInstance);
            System.out.println("First attribute: " + sparseInstance.attribute(0));
            System.out.println("Class attribute: " + sparseInstance.classAttribute());
            System.out.println("Class index: " + sparseInstance.classIndex());
            System.out.println("Class is missing: " + sparseInstance.classIsMissing());
            System.out.println("Class value (internal format): " + sparseInstance.classValue());
            SparseInstance sparseInstance2 = (SparseInstance)sparseInstance.copy();
            System.out.println("Shallow copy: " + sparseInstance2);
            sparseInstance2.setDataset(sparseInstance.dataset());
            System.out.println("Shallow copy with dataset set: " + sparseInstance2);
            System.out.print("All stored values in internal format: ");
            for (n = 0; n < sparseInstance.numValues(); ++n) {
                if (n > 0) {
                    System.out.print(",");
                }
                System.out.print(sparseInstance.valueSparse(n));
            }
            System.out.println();
            System.out.print("All values set to zero: ");
            while (sparseInstance.numValues() > 0) {
                sparseInstance.setValueSparse(0, 0.0);
            }
            for (n = 0; n < sparseInstance.numValues(); ++n) {
                if (n > 0) {
                    System.out.print(",");
                }
                System.out.print(sparseInstance.valueSparse(n));
            }
            System.out.println();
            System.out.print("All values set to one: ");
            for (n = 0; n < sparseInstance.numAttributes(); ++n) {
                sparseInstance.setValue(n, 1.0);
            }
            for (n = 0; n < sparseInstance.numValues(); ++n) {
                if (n > 0) {
                    System.out.print(",");
                }
                System.out.print(sparseInstance.valueSparse(n));
            }
            System.out.println();
            sparseInstance2.setDataset(null);
            sparseInstance2.deleteAttributeAt(0);
            sparseInstance2.insertAttributeAt(0);
            sparseInstance2.setDataset(sparseInstance.dataset());
            System.out.println("Copy with first attribute deleted and inserted: " + sparseInstance2);
            sparseInstance2.setDataset(null);
            sparseInstance2.deleteAttributeAt(1);
            sparseInstance2.insertAttributeAt(1);
            sparseInstance2.setDataset(sparseInstance.dataset());
            System.out.println("Copy with second attribute deleted and inserted: " + sparseInstance2);
            sparseInstance2.setDataset(null);
            sparseInstance2.deleteAttributeAt(2);
            sparseInstance2.insertAttributeAt(2);
            sparseInstance2.setDataset(sparseInstance.dataset());
            System.out.println("Copy with third attribute deleted and inserted: " + sparseInstance2);
            System.out.println("Enumerating attributes (leaving out class):");
            Enumeration enumeration = sparseInstance.enumerateAttributes();
            while (enumeration.hasMoreElements()) {
                object = (Attribute)enumeration.nextElement();
                System.out.println(object);
            }
            System.out.println("Header of original and copy equivalent: " + sparseInstance.equalHeaders(sparseInstance2));
            System.out.println("Length of copy missing: " + sparseInstance2.isMissing(attribute));
            System.out.println("Weight of copy missing: " + sparseInstance2.isMissing(attribute2.index()));
            System.out.println("Length of copy missing: " + Instance.isMissingValue(sparseInstance2.value(attribute)));
            System.out.println("Missing value coded as: " + Instance.missingValue());
            System.out.println("Number of attributes: " + sparseInstance2.numAttributes());
            System.out.println("Number of classes: " + sparseInstance2.numClasses());
            object = new double[]{2.0, 3.0, 0.0};
            sparseInstance2.replaceMissingValues((double[])object);
            System.out.println("Copy with missing value replaced: " + sparseInstance2);
            sparseInstance2.setClassMissing();
            System.out.println("Copy with missing class: " + sparseInstance2);
            sparseInstance2.setClassValue(0.0);
            System.out.println("Copy with class value set to first value: " + sparseInstance2);
            sparseInstance2.setClassValue("third");
            System.out.println("Copy with class value set to \"third\": " + sparseInstance2);
            sparseInstance2.setMissing(1);
            System.out.println("Copy with second attribute set to be missing: " + sparseInstance2);
            sparseInstance2.setMissing(attribute);
            System.out.println("Copy with length set to be missing: " + sparseInstance2);
            sparseInstance2.setValue(0, 0.0);
            System.out.println("Copy with first attribute set to 0: " + sparseInstance2);
            sparseInstance2.setValue(attribute2, 1.0);
            System.out.println("Copy with weight attribute set to 1: " + sparseInstance2);
            sparseInstance2.setValue(attribute3, "second");
            System.out.println("Copy with position set to \"second\": " + sparseInstance2);
            sparseInstance2.setValue(2, "first");
            System.out.println("Copy with last attribute set to \"first\": " + sparseInstance2);
            System.out.println("Current weight of instance copy: " + sparseInstance2.weight());
            sparseInstance2.setWeight(2.0);
            System.out.println("Current weight of instance copy (set to 2): " + sparseInstance2.weight());
            System.out.println("Last value of copy: " + sparseInstance2.toString(2));
            System.out.println("Value of position for copy: " + sparseInstance2.toString(attribute3));
            System.out.println("Last value of copy (internal format): " + sparseInstance2.value(2));
            System.out.println("Value of position for copy (internal format): " + sparseInstance2.value(attribute3));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.23 $");
    }
}

