/*
 * Decompiled with CFR 0.152.
 */
package weka.core.parser.JFlex;

import weka.core.parser.JFlex.StateSet;

public final class StateSetEnumerator {
    private static final boolean DEBUG = false;
    private int index;
    private int offset;
    private long mask;
    private int current;
    private long[] bits;

    public StateSetEnumerator() {
    }

    public StateSetEnumerator(StateSet stateSet) {
        this.reset(stateSet);
    }

    public void reset(StateSet stateSet) {
        this.bits = stateSet.bits;
        this.index = 0;
        this.offset = 0;
        this.mask = 1L;
        this.current = 0;
        while (this.index < this.bits.length && this.bits[this.index] == 0L) {
            ++this.index;
        }
        if (this.index >= this.bits.length) {
            return;
        }
        while (this.offset <= 63 && (this.bits[this.index] & this.mask) == 0L) {
            this.mask <<= 1;
            ++this.offset;
        }
    }

    private void advance() {
        int n = this.index;
        int n2 = this.offset;
        long l = this.mask;
        long[] lArray = this.bits;
        long l2 = lArray[n];
        while (++n2 <= 63 && (l2 & (l <<= 1)) == 0L) {
        }
        if (n2 > 63) {
            int n3 = lArray.length;
            while (++n < n3 && lArray[n] == 0L) {
            }
            if (n >= n3) {
                this.index = n3;
                return;
            }
            n2 = 0;
            l = 1L;
            l2 = lArray[n];
            while ((l2 & l) == 0L) {
                l <<= 1;
                ++n2;
            }
        }
        this.index = n;
        this.mask = l;
        this.offset = n2;
    }

    public boolean hasMoreElements() {
        return this.index < this.bits.length;
    }

    public int nextElement() {
        int n = (this.index << 6) + this.offset;
        this.advance();
        return n;
    }
}

