/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules;

import java.io.Serializable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class DecisionTableHashKey
implements Serializable,
RevisionHandler {
    static final long serialVersionUID = 5674163500154964602L;
    private double[] attributes;
    private boolean[] missing;
    private int key;

    public DecisionTableHashKey(Instance instance, int n, boolean bl) throws Exception {
        int n2 = instance.classIndex();
        this.key = -999;
        this.attributes = new double[n];
        this.missing = new boolean[n];
        for (int i = 0; i < n; ++i) {
            if (i == n2 && !bl) {
                this.missing[i] = true;
                continue;
            }
            this.missing[i] = instance.isMissing(i);
            if (this.missing[i]) continue;
            this.attributes[i] = instance.value(i);
        }
    }

    public String toString(Instances instances, int n) {
        int n2 = instances.classIndex();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.attributes.length; ++i) {
            if (i == n2) continue;
            if (this.missing[i]) {
                stringBuffer.append("?");
                for (int j = 0; j < n; ++j) {
                    stringBuffer.append(" ");
                }
                continue;
            }
            String string = instances.attribute(i).value((int)this.attributes[i]);
            StringBuffer stringBuffer2 = new StringBuffer(string);
            for (int j = 0; j < n - string.length() + 1; ++j) {
                stringBuffer2.append(" ");
            }
            stringBuffer.append(stringBuffer2);
        }
        return stringBuffer.toString();
    }

    public DecisionTableHashKey(double[] dArray) {
        int n = dArray.length;
        this.key = -999;
        this.attributes = new double[n];
        this.missing = new boolean[n];
        for (int i = 0; i < n; ++i) {
            if (dArray[i] == Double.MAX_VALUE) {
                this.missing[i] = true;
                continue;
            }
            this.missing[i] = false;
            this.attributes[i] = dArray[i];
        }
    }

    public int hashCode() {
        int n = 0;
        if (this.key != -999) {
            return this.key;
        }
        for (int i = 0; i < this.attributes.length; ++i) {
            if (this.missing[i]) {
                n += i * 13;
                continue;
            }
            n = (int)((double)n + (double)(i * 5) * (this.attributes[i] + 1.0));
        }
        if (this.key == -999) {
            this.key = n;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        boolean bl = true;
        if (object instanceof DecisionTableHashKey) {
            DecisionTableHashKey decisionTableHashKey = (DecisionTableHashKey)object;
            for (int i = 0; i < this.attributes.length; ++i) {
                boolean bl2 = decisionTableHashKey.missing[i];
                if (this.missing[i] || bl2) {
                    if ((!this.missing[i] || bl2) && (this.missing[i] || !bl2)) continue;
                    bl = false;
                } else {
                    if (this.attributes[i] == decisionTableHashKey.attributes[i]) continue;
                    bl = false;
                }
                break;
            }
        } else {
            return false;
        }
        return bl;
    }

    public void print_hash_code() {
        System.out.println("Hash val: " + this.hashCode());
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.3 $");
    }
}

