/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.functions.Logistic;
import weka.classifiers.functions.supportVector.Kernel;
import weka.classifiers.functions.supportVector.PolyKernel;
import weka.classifiers.functions.supportVector.SMOset;
import weka.classifiers.meta.MultiClassClassifier;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.NominalToBinary;
import weka.filters.unsupervised.attribute.Normalize;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;
import weka.filters.unsupervised.attribute.Standardize;

public class SMO
extends Classifier
implements WeightedInstancesHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = -6585883636378691736L;
    public static final int FILTER_NORMALIZE = 0;
    public static final int FILTER_STANDARDIZE = 1;
    public static final int FILTER_NONE = 2;
    public static final Tag[] TAGS_FILTER = new Tag[]{new Tag(0, "Normalize training data"), new Tag(1, "Standardize training data"), new Tag(2, "No normalization/standardization")};
    protected BinarySMO[][] m_classifiers = null;
    protected double m_C = 1.0;
    protected double m_eps = 1.0E-12;
    protected double m_tol = 0.001;
    protected int m_filterType = 0;
    protected NominalToBinary m_NominalToBinary;
    protected Filter m_Filter = null;
    protected ReplaceMissingValues m_Missing;
    protected int m_classIndex = -1;
    protected Attribute m_classAttribute;
    protected boolean m_KernelIsLinear = false;
    protected boolean m_checksTurnedOff;
    protected static double m_Del = 4.94E-321;
    protected boolean m_fitLogisticModels = false;
    protected int m_numFolds = -1;
    protected int m_randomSeed = 1;
    protected Kernel m_kernel = new PolyKernel();

    public String globalInfo() {
        return "Implements John Platt's sequential minimal optimization algorithm for training a support vector classifier.\n\nThis implementation globally replaces all missing values and transforms nominal attributes into binary ones. It also normalizes all attributes by default. (In that case the coefficients in the output are based on the normalized data, not the original data --- this is important for interpreting the classifier.)\n\nMulti-class problems are solved using pairwise classification (1-vs-1 and if logistic models are built pairwise coupling according to Hastie and Tibshirani, 1998).\n\nTo obtain proper probability estimates, use the option that fits logistic regression models to the outputs of the support vector machine. In the multi-class case the predicted probabilities are coupled using Hastie and Tibshirani's pairwise coupling method.\n\nNote: for improved speed normalization should be turned off when operating on SparseInstances.\n\nFor more information on the SMO algorithm, see\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INCOLLECTION);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "J. Platt");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1998");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Machines using Sequential Minimal Optimization");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "Advances in Kernel Methods - Support Vector Learning");
        technicalInformation.setValue(TechnicalInformation.Field.EDITOR, "B. Schoelkopf and C. Burges and A. Smola");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "MIT Press");
        technicalInformation.setValue(TechnicalInformation.Field.URL, "http://research.microsoft.com/~jplatt/smo.html");
        technicalInformation.setValue(TechnicalInformation.Field.PDF, "http://research.microsoft.com/~jplatt/smo-book.pdf");
        technicalInformation.setValue(TechnicalInformation.Field.PS, "http://research.microsoft.com/~jplatt/smo-book.ps.gz");
        TechnicalInformation technicalInformation2 = technicalInformation.add(TechnicalInformation.Type.ARTICLE);
        technicalInformation2.setValue(TechnicalInformation.Field.AUTHOR, "S.S. Keerthi and S.K. Shevade and C. Bhattacharyya and K.R.K. Murthy");
        technicalInformation2.setValue(TechnicalInformation.Field.YEAR, "2001");
        technicalInformation2.setValue(TechnicalInformation.Field.TITLE, "Improvements to Platt's SMO Algorithm for SVM Classifier Design");
        technicalInformation2.setValue(TechnicalInformation.Field.JOURNAL, "Neural Computation");
        technicalInformation2.setValue(TechnicalInformation.Field.VOLUME, "13");
        technicalInformation2.setValue(TechnicalInformation.Field.NUMBER, "3");
        technicalInformation2.setValue(TechnicalInformation.Field.PAGES, "637-649");
        technicalInformation2.setValue(TechnicalInformation.Field.PS, "http://guppy.mpe.nus.edu.sg/~mpessk/svm/smo_mod_nc.ps.gz");
        technicalInformation2 = technicalInformation.add(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation2.setValue(TechnicalInformation.Field.AUTHOR, "Trevor Hastie and Robert Tibshirani");
        technicalInformation2.setValue(TechnicalInformation.Field.YEAR, "1998");
        technicalInformation2.setValue(TechnicalInformation.Field.TITLE, "Classification by Pairwise Coupling");
        technicalInformation2.setValue(TechnicalInformation.Field.BOOKTITLE, "Advances in Neural Information Processing Systems");
        technicalInformation2.setValue(TechnicalInformation.Field.VOLUME, "10");
        technicalInformation2.setValue(TechnicalInformation.Field.PUBLISHER, "MIT Press");
        technicalInformation2.setValue(TechnicalInformation.Field.EDITOR, "Michael I. Jordan and Michael J. Kearns and Sara A. Solla");
        technicalInformation2.setValue(TechnicalInformation.Field.PS, "http://www-stat.stanford.edu/~hastie/Papers/2class.ps");
        return technicalInformation;
    }

    public void turnChecksOff() {
        this.m_checksTurnedOff = true;
    }

    public void turnChecksOn() {
        this.m_checksTurnedOff = false;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = this.getKernel().getCapabilities();
        capabilities.setOwner(this);
        capabilities.enableAllAttributeDependencies();
        if (capabilities.handles(Capabilities.Capability.NUMERIC_ATTRIBUTES)) {
            capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        }
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.disableAllClasses();
        capabilities.disableAllClassDependencies();
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        int n;
        if (!this.m_checksTurnedOff) {
            this.getCapabilities().testWithFail(instances);
            instances = new Instances(instances);
            instances.deleteWithMissingClass();
            Instances instances2 = new Instances(instances, instances.numInstances());
            for (n = 0; n < instances.numInstances(); ++n) {
                if (!(instances.instance(n).weight() > 0.0)) continue;
                instances2.add(instances.instance(n));
            }
            if (instances2.numInstances() == 0) {
                throw new Exception("No training instances left after removing instances with weight 0!");
            }
            instances = instances2;
        }
        if (!this.m_checksTurnedOff) {
            this.m_Missing = new ReplaceMissingValues();
            this.m_Missing.setInputFormat(instances);
            instances = Filter.useFilter(instances, this.m_Missing);
        } else {
            this.m_Missing = null;
        }
        if (this.getCapabilities().handles(Capabilities.Capability.NUMERIC_ATTRIBUTES)) {
            boolean bl = true;
            if (!this.m_checksTurnedOff) {
                for (n = 0; n < instances.numAttributes(); ++n) {
                    if (n == instances.classIndex() || instances.attribute(n).isNumeric()) continue;
                    bl = false;
                    break;
                }
            }
            if (!bl) {
                this.m_NominalToBinary = new NominalToBinary();
                this.m_NominalToBinary.setInputFormat(instances);
                instances = Filter.useFilter(instances, this.m_NominalToBinary);
            } else {
                this.m_NominalToBinary = null;
            }
        } else {
            this.m_NominalToBinary = null;
        }
        if (this.m_filterType == 1) {
            this.m_Filter = new Standardize();
            this.m_Filter.setInputFormat(instances);
            instances = Filter.useFilter(instances, this.m_Filter);
        } else if (this.m_filterType == 0) {
            this.m_Filter = new Normalize();
            this.m_Filter.setInputFormat(instances);
            instances = Filter.useFilter(instances, this.m_Filter);
        } else {
            this.m_Filter = null;
        }
        this.m_classIndex = instances.classIndex();
        this.m_classAttribute = instances.classAttribute();
        this.m_KernelIsLinear = this.m_kernel instanceof PolyKernel && ((PolyKernel)this.m_kernel).getExponent() == 1.0;
        Instances[] instancesArray = new Instances[instances.numClasses()];
        for (n = 0; n < instances.numClasses(); ++n) {
            instancesArray[n] = new Instances(instances, instances.numInstances());
        }
        for (n = 0; n < instances.numInstances(); ++n) {
            Instance instance = instances.instance(n);
            instancesArray[(int)instance.classValue()].add(instance);
        }
        for (n = 0; n < instances.numClasses(); ++n) {
            instancesArray[n].compactify();
        }
        Random random = new Random(this.m_randomSeed);
        this.m_classifiers = new BinarySMO[instances.numClasses()][instances.numClasses()];
        for (int i = 0; i < instances.numClasses(); ++i) {
            for (int j = i + 1; j < instances.numClasses(); ++j) {
                int n2;
                this.m_classifiers[i][j] = new BinarySMO();
                this.m_classifiers[i][j].setKernel(Kernel.makeCopy(this.getKernel()));
                Instances instances3 = new Instances(instances, instances.numInstances());
                for (n2 = 0; n2 < instancesArray[i].numInstances(); ++n2) {
                    instances3.add(instancesArray[i].instance(n2));
                }
                for (n2 = 0; n2 < instancesArray[j].numInstances(); ++n2) {
                    instances3.add(instancesArray[j].instance(n2));
                }
                instances3.compactify();
                instances3.randomize(random);
                this.m_classifiers[i][j].buildClassifier(instances3, i, j, this.m_fitLogisticModels, this.m_numFolds, this.m_randomSeed);
            }
        }
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        if (!this.m_checksTurnedOff) {
            this.m_Missing.input(instance);
            this.m_Missing.batchFinished();
            instance = this.m_Missing.output();
        }
        if (this.m_NominalToBinary != null) {
            this.m_NominalToBinary.input(instance);
            this.m_NominalToBinary.batchFinished();
            instance = this.m_NominalToBinary.output();
        }
        if (this.m_Filter != null) {
            this.m_Filter.input(instance);
            this.m_Filter.batchFinished();
            instance = this.m_Filter.output();
        }
        if (!this.m_fitLogisticModels) {
            double[] dArray = new double[instance.numClasses()];
            for (int i = 0; i < instance.numClasses(); ++i) {
                for (int j = i + 1; j < instance.numClasses(); ++j) {
                    if (this.m_classifiers[i][j].m_alpha == null && this.m_classifiers[i][j].m_sparseWeights == null) continue;
                    double d = this.m_classifiers[i][j].SVMOutput(-1, instance);
                    if (d > 0.0) {
                        int n = j;
                        dArray[n] = dArray[n] + 1.0;
                        continue;
                    }
                    int n = i;
                    dArray[n] = dArray[n] + 1.0;
                }
            }
            Utils.normalize(dArray);
            return dArray;
        }
        if (instance.numClasses() == 2) {
            double[] dArray = new double[]{this.m_classifiers[0][1].SVMOutput(-1, instance), Instance.missingValue()};
            return this.m_classifiers[0][1].m_logistic.distributionForInstance(new Instance(1.0, dArray));
        }
        double[][] dArray = new double[instance.numClasses()][instance.numClasses()];
        double[][] dArray2 = new double[instance.numClasses()][instance.numClasses()];
        for (int i = 0; i < instance.numClasses(); ++i) {
            for (int j = i + 1; j < instance.numClasses(); ++j) {
                if (this.m_classifiers[i][j].m_alpha == null && this.m_classifiers[i][j].m_sparseWeights == null) continue;
                double[] dArray3 = new double[]{this.m_classifiers[i][j].SVMOutput(-1, instance), Instance.missingValue()};
                dArray[i][j] = this.m_classifiers[i][j].m_logistic.distributionForInstance(new Instance(1.0, dArray3))[0];
                dArray2[i][j] = this.m_classifiers[i][j].m_sumOfWeights;
            }
        }
        return MultiClassClassifier.pairwiseCoupling(dArray2, dArray);
    }

    public int[] obtainVotes(Instance instance) throws Exception {
        if (!this.m_checksTurnedOff) {
            this.m_Missing.input(instance);
            this.m_Missing.batchFinished();
            instance = this.m_Missing.output();
        }
        if (this.m_NominalToBinary != null) {
            this.m_NominalToBinary.input(instance);
            this.m_NominalToBinary.batchFinished();
            instance = this.m_NominalToBinary.output();
        }
        if (this.m_Filter != null) {
            this.m_Filter.input(instance);
            this.m_Filter.batchFinished();
            instance = this.m_Filter.output();
        }
        int[] nArray = new int[instance.numClasses()];
        for (int i = 0; i < instance.numClasses(); ++i) {
            for (int j = i + 1; j < instance.numClasses(); ++j) {
                double d = this.m_classifiers[i][j].SVMOutput(-1, instance);
                if (d > 0.0) {
                    int n = j;
                    nArray[n] = nArray[n] + 1;
                    continue;
                }
                int n = i;
                nArray[n] = nArray[n] + 1;
            }
        }
        return nArray;
    }

    public double[][][] sparseWeights() {
        int n = this.m_classAttribute.numValues();
        double[][][] dArray = new double[n][n][];
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                dArray[i][j] = this.m_classifiers[i][j].m_sparseWeights;
            }
        }
        return dArray;
    }

    public int[][][] sparseIndices() {
        int n = this.m_classAttribute.numValues();
        int[][][] nArray = new int[n][n][];
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                nArray[i][j] = this.m_classifiers[i][j].m_sparseIndices;
            }
        }
        return nArray;
    }

    public double[][] bias() {
        int n = this.m_classAttribute.numValues();
        double[][] dArray = new double[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                dArray[i][j] = this.m_classifiers[i][j].m_b;
            }
        }
        return dArray;
    }

    public int numClassAttributeValues() {
        return this.m_classAttribute.numValues();
    }

    public String[] classAttributeNames() {
        int n = this.m_classAttribute.numValues();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.m_classAttribute.value(i);
        }
        return stringArray;
    }

    public String[][][] attributeNames() {
        int n = this.m_classAttribute.numValues();
        String[][][] stringArray = new String[n][n][];
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                int n2 = this.m_classifiers[i][j].m_data.numAttributes();
                String[] stringArray2 = new String[n2];
                for (int k = 0; k < n2; ++k) {
                    stringArray2[k] = this.m_classifiers[i][j].m_data.attribute(k).name();
                }
                stringArray[i][j] = stringArray2;
            }
        }
        return stringArray;
    }

    public Enumeration listOptions() {
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        vector.addElement(new Option("\tTurns off all checks - use with caution!\n\tTurning them off assumes that data is purely numeric, doesn't\n\tcontain any missing values, and has a nominal class. Turning them\n\toff also means that no header information will be stored if the\n\tmachine is linear. Finally, it also assumes that no instance has\n\ta weight equal to 0.\n\t(default: checks on)", "no-checks", 0, "-no-checks"));
        vector.addElement(new Option("\tThe complexity constant C. (default 1)", "C", 1, "-C <double>"));
        vector.addElement(new Option("\tWhether to 0=normalize/1=standardize/2=neither. (default 0=normalize)", "N", 1, "-N"));
        vector.addElement(new Option("\tThe tolerance parameter. (default 1.0e-3)", "L", 1, "-L <double>"));
        vector.addElement(new Option("\tThe epsilon for round-off error. (default 1.0e-12)", "P", 1, "-P <double>"));
        vector.addElement(new Option("\tFit logistic models to SVM outputs. ", "M", 0, "-M"));
        vector.addElement(new Option("\tThe number of folds for the internal\n\tcross-validation. (default -1, use training data)", "V", 1, "-V <double>"));
        vector.addElement(new Option("\tThe random number seed. (default 1)", "W", 1, "-W <double>"));
        vector.addElement(new Option("\tThe Kernel to use.\n\t(default: weka.classifiers.functions.supportVector.PolyKernel)", "K", 1, "-K <classname and parameters>"));
        vector.addElement(new Option("", "", 0, "\nOptions specific to kernel " + this.getKernel().getClass().getName() + ":"));
        enumeration = this.getKernel().listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setChecksTurnedOff(Utils.getFlag("no-checks", stringArray));
        String string = Utils.getOption('C', stringArray);
        if (string.length() != 0) {
            this.setC(Double.parseDouble(string));
        } else {
            this.setC(1.0);
        }
        string = Utils.getOption('L', stringArray);
        if (string.length() != 0) {
            this.setToleranceParameter(Double.parseDouble(string));
        } else {
            this.setToleranceParameter(0.001);
        }
        string = Utils.getOption('P', stringArray);
        if (string.length() != 0) {
            this.setEpsilon(Double.parseDouble(string));
        } else {
            this.setEpsilon(1.0E-12);
        }
        string = Utils.getOption('N', stringArray);
        if (string.length() != 0) {
            this.setFilterType(new SelectedTag(Integer.parseInt(string), TAGS_FILTER));
        } else {
            this.setFilterType(new SelectedTag(0, TAGS_FILTER));
        }
        this.setBuildLogisticModels(Utils.getFlag('M', stringArray));
        string = Utils.getOption('V', stringArray);
        if (string.length() != 0) {
            this.setNumFolds(Integer.parseInt(string));
        } else {
            this.setNumFolds(-1);
        }
        string = Utils.getOption('W', stringArray);
        if (string.length() != 0) {
            this.setRandomSeed(Integer.parseInt(string));
        } else {
            this.setRandomSeed(1);
        }
        string = Utils.getOption('K', stringArray);
        String[] stringArray2 = Utils.splitOptions(string);
        if (stringArray2.length != 0) {
            string = stringArray2[0];
            stringArray2[0] = "";
            this.setKernel(Kernel.forName(string, stringArray2));
        }
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        if (this.getChecksTurnedOff()) {
            vector.add("-no-checks");
        }
        vector.add("-C");
        vector.add("" + this.getC());
        vector.add("-L");
        vector.add("" + this.getToleranceParameter());
        vector.add("-P");
        vector.add("" + this.getEpsilon());
        vector.add("-N");
        vector.add("" + this.m_filterType);
        if (this.getBuildLogisticModels()) {
            vector.add("-M");
        }
        vector.add("-V");
        vector.add("" + this.getNumFolds());
        vector.add("-W");
        vector.add("" + this.getRandomSeed());
        vector.add("-K");
        vector.add("" + this.getKernel().getClass().getName() + " " + Utils.joinOptions(this.getKernel().getOptions()));
        return vector.toArray(new String[vector.size()]);
    }

    public void setChecksTurnedOff(boolean bl) {
        if (bl) {
            this.turnChecksOff();
        } else {
            this.turnChecksOn();
        }
    }

    public boolean getChecksTurnedOff() {
        return this.m_checksTurnedOff;
    }

    public String checksTurnedOffTipText() {
        return "Turns time-consuming checks off - use with caution.";
    }

    public String kernelTipText() {
        return "The kernel to use.";
    }

    public void setKernel(Kernel kernel) {
        this.m_kernel = kernel;
    }

    public Kernel getKernel() {
        return this.m_kernel;
    }

    public String cTipText() {
        return "The complexity parameter C.";
    }

    public double getC() {
        return this.m_C;
    }

    public void setC(double d) {
        this.m_C = d;
    }

    public String toleranceParameterTipText() {
        return "The tolerance parameter (shouldn't be changed).";
    }

    public double getToleranceParameter() {
        return this.m_tol;
    }

    public void setToleranceParameter(double d) {
        this.m_tol = d;
    }

    public String epsilonTipText() {
        return "The epsilon for round-off error (shouldn't be changed).";
    }

    public double getEpsilon() {
        return this.m_eps;
    }

    public void setEpsilon(double d) {
        this.m_eps = d;
    }

    public String filterTypeTipText() {
        return "Determines how/if the data will be transformed.";
    }

    public SelectedTag getFilterType() {
        return new SelectedTag(this.m_filterType, TAGS_FILTER);
    }

    public void setFilterType(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_FILTER) {
            this.m_filterType = selectedTag.getSelectedTag().getID();
        }
    }

    public String buildLogisticModelsTipText() {
        return "Whether to fit logistic models to the outputs (for proper probability estimates).";
    }

    public boolean getBuildLogisticModels() {
        return this.m_fitLogisticModels;
    }

    public void setBuildLogisticModels(boolean bl) {
        this.m_fitLogisticModels = bl;
    }

    public String numFoldsTipText() {
        return "The number of folds for cross-validation used to generate training data for logistic models (-1 means use training data).";
    }

    public int getNumFolds() {
        return this.m_numFolds;
    }

    public void setNumFolds(int n) {
        this.m_numFolds = n;
    }

    public String randomSeedTipText() {
        return "Random number seed for the cross-validation.";
    }

    public int getRandomSeed() {
        return this.m_randomSeed;
    }

    public void setRandomSeed(int n) {
        this.m_randomSeed = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_classAttribute == null) {
            return "SMO: No model built yet.";
        }
        try {
            stringBuffer.append("SMO\n\n");
            stringBuffer.append("Kernel used:\n  " + this.m_kernel.toString() + "\n\n");
            for (int i = 0; i < this.m_classAttribute.numValues(); ++i) {
                for (int j = i + 1; j < this.m_classAttribute.numValues(); ++j) {
                    stringBuffer.append("Classifier for classes: " + this.m_classAttribute.value(i) + ", " + this.m_classAttribute.value(j) + "\n\n");
                    stringBuffer.append(this.m_classifiers[i][j]);
                    if (this.m_fitLogisticModels) {
                        stringBuffer.append("\n\n");
                        if (this.m_classifiers[i][j].m_logistic == null) {
                            stringBuffer.append("No logistic model has been fit.\n");
                        } else {
                            stringBuffer.append(this.m_classifiers[i][j].m_logistic);
                        }
                    }
                    stringBuffer.append("\n\n");
                }
            }
        }
        catch (Exception exception) {
            return "Can't print SMO classifier.";
        }
        return stringBuffer.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.69 $");
    }

    public static void main(String[] stringArray) {
        SMO.runClassifier(new SMO(), stringArray);
    }

    public class BinarySMO
    implements Serializable {
        static final long serialVersionUID = -8246163625699362456L;
        protected double[] m_alpha;
        protected double m_b;
        protected double m_bLow;
        protected double m_bUp;
        protected int m_iLow;
        protected int m_iUp;
        protected Instances m_data;
        protected double[] m_weights;
        protected double[] m_sparseWeights;
        protected int[] m_sparseIndices;
        protected Kernel m_kernel;
        protected double[] m_class;
        protected double[] m_errors;
        protected SMOset m_I0;
        protected SMOset m_I1;
        protected SMOset m_I2;
        protected SMOset m_I3;
        protected SMOset m_I4;
        protected SMOset m_supportVectors;
        protected Logistic m_logistic = null;
        protected double m_sumOfWeights = 0.0;

        protected void fitLogistic(Instances instances, int n, int n2, int n3, Random random) throws Exception {
            FastVector fastVector = new FastVector(2);
            fastVector.addElement(new Attribute("pred"));
            FastVector fastVector2 = new FastVector(2);
            fastVector2.addElement(instances.classAttribute().value(n));
            fastVector2.addElement(instances.classAttribute().value(n2));
            fastVector.addElement(new Attribute("class", fastVector2));
            Instances instances2 = new Instances("data", fastVector, instances.numInstances());
            instances2.setClassIndex(1);
            if (n3 <= 0) {
                for (int i = 0; i < instances.numInstances(); ++i) {
                    Instance instance = instances.instance(i);
                    double[] dArray = new double[2];
                    dArray[0] = this.SVMOutput(-1, instance);
                    if (instance.classValue() == (double)n2) {
                        dArray[1] = 1.0;
                    }
                    instances2.add(new Instance(instance.weight(), dArray));
                }
            } else {
                if (n3 > instances.numInstances()) {
                    n3 = instances.numInstances();
                }
                instances = new Instances(instances);
                instances.randomize(random);
                instances.stratify(n3);
                for (int i = 0; i < n3; ++i) {
                    Instances instances3 = instances.trainCV(n3, i, random);
                    BinarySMO binarySMO = new BinarySMO();
                    binarySMO.setKernel(Kernel.makeCopy(SMO.this.m_kernel));
                    binarySMO.buildClassifier(instances3, n, n2, false, -1, -1);
                    Instances instances4 = instances.testCV(n3, i);
                    for (int j = 0; j < instances4.numInstances(); ++j) {
                        double[] dArray = new double[2];
                        dArray[0] = binarySMO.SVMOutput(-1, instances4.instance(j));
                        if (instances4.instance(j).classValue() == (double)n2) {
                            dArray[1] = 1.0;
                        }
                        instances2.add(new Instance(instances4.instance(j).weight(), dArray));
                    }
                }
            }
            this.m_logistic = new Logistic();
            this.m_logistic.buildClassifier(instances2);
        }

        public void setKernel(Kernel kernel) {
            this.m_kernel = kernel;
        }

        public Kernel getKernel() {
            return this.m_kernel;
        }

        protected void buildClassifier(Instances instances, int n, int n2, boolean bl, int n3, int n4) throws Exception {
            int n5;
            this.m_bUp = -1.0;
            this.m_bLow = 1.0;
            this.m_b = 0.0;
            this.m_alpha = null;
            this.m_data = null;
            this.m_weights = null;
            this.m_errors = null;
            this.m_logistic = null;
            this.m_I0 = null;
            this.m_I1 = null;
            this.m_I2 = null;
            this.m_I3 = null;
            this.m_I4 = null;
            this.m_sparseWeights = null;
            this.m_sparseIndices = null;
            this.m_sumOfWeights = instances.sumOfWeights();
            this.m_class = new double[instances.numInstances()];
            this.m_iUp = -1;
            this.m_iLow = -1;
            for (n5 = 0; n5 < this.m_class.length; ++n5) {
                if ((int)instances.instance(n5).classValue() == n) {
                    this.m_class[n5] = -1.0;
                    this.m_iLow = n5;
                    continue;
                }
                if ((int)instances.instance(n5).classValue() == n2) {
                    this.m_class[n5] = 1.0;
                    this.m_iUp = n5;
                    continue;
                }
                throw new Exception("This should never happen!");
            }
            if (this.m_iUp == -1 || this.m_iLow == -1) {
                if (this.m_iUp != -1) {
                    this.m_b = -1.0;
                } else if (this.m_iLow != -1) {
                    this.m_b = 1.0;
                } else {
                    this.m_class = null;
                    return;
                }
                if (SMO.this.m_KernelIsLinear) {
                    this.m_sparseWeights = new double[0];
                    this.m_sparseIndices = new int[0];
                    this.m_class = null;
                } else {
                    this.m_supportVectors = new SMOset(0);
                    this.m_alpha = new double[0];
                    this.m_class = new double[0];
                }
                if (bl) {
                    this.fitLogistic(instances, n, n2, n3, new Random(n4));
                }
                return;
            }
            this.m_data = instances;
            this.m_weights = (double[])(SMO.this.m_KernelIsLinear ? new double[this.m_data.numAttributes()] : null);
            this.m_alpha = new double[this.m_data.numInstances()];
            this.m_supportVectors = new SMOset(this.m_data.numInstances());
            this.m_I0 = new SMOset(this.m_data.numInstances());
            this.m_I1 = new SMOset(this.m_data.numInstances());
            this.m_I2 = new SMOset(this.m_data.numInstances());
            this.m_I3 = new SMOset(this.m_data.numInstances());
            this.m_I4 = new SMOset(this.m_data.numInstances());
            this.m_sparseWeights = null;
            this.m_sparseIndices = null;
            this.m_kernel.buildKernel(this.m_data);
            this.m_errors = new double[this.m_data.numInstances()];
            this.m_errors[this.m_iLow] = 1.0;
            this.m_errors[this.m_iUp] = -1.0;
            for (n5 = 0; n5 < this.m_class.length; ++n5) {
                if (this.m_class[n5] == 1.0) {
                    this.m_I1.insert(n5);
                    continue;
                }
                this.m_I4.insert(n5);
            }
            n5 = 0;
            boolean bl2 = true;
            while (n5 > 0 || bl2) {
                int n6;
                n5 = 0;
                if (bl2) {
                    for (n6 = 0; n6 < this.m_alpha.length; ++n6) {
                        if (!this.examineExample(n6)) continue;
                        ++n5;
                    }
                } else {
                    for (n6 = 0; n6 < this.m_alpha.length; ++n6) {
                        if (!(this.m_alpha[n6] > 0.0) || !(this.m_alpha[n6] < SMO.this.m_C * this.m_data.instance(n6).weight())) continue;
                        if (this.examineExample(n6)) {
                            ++n5;
                        }
                        if (!(this.m_bUp > this.m_bLow - 2.0 * SMO.this.m_tol)) continue;
                        n5 = 0;
                        break;
                    }
                }
                if (bl2) {
                    bl2 = false;
                    continue;
                }
                if (n5 != 0) continue;
                bl2 = true;
            }
            this.m_b = (this.m_bLow + this.m_bUp) / 2.0;
            this.m_kernel.clean();
            this.m_errors = null;
            this.m_I4 = null;
            this.m_I3 = null;
            this.m_I2 = null;
            this.m_I1 = null;
            this.m_I0 = null;
            if (SMO.this.m_KernelIsLinear) {
                this.m_supportVectors = null;
                this.m_class = null;
                this.m_data = !SMO.this.m_checksTurnedOff ? new Instances(this.m_data, 0) : null;
                double[] dArray = new double[this.m_weights.length];
                int[] nArray = new int[this.m_weights.length];
                int n7 = 0;
                for (int i = 0; i < this.m_weights.length; ++i) {
                    if (this.m_weights[i] == 0.0) continue;
                    dArray[n7] = this.m_weights[i];
                    nArray[n7] = i;
                    ++n7;
                }
                this.m_sparseWeights = new double[n7];
                this.m_sparseIndices = new int[n7];
                System.arraycopy(dArray, 0, this.m_sparseWeights, 0, n7);
                System.arraycopy(nArray, 0, this.m_sparseIndices, 0, n7);
                this.m_weights = null;
                this.m_alpha = null;
            }
            if (bl) {
                this.fitLogistic(instances, n, n2, n3, new Random(n4));
            }
        }

        public double SVMOutput(int n, Instance instance) throws Exception {
            double d = 0.0;
            if (SMO.this.m_KernelIsLinear) {
                if (this.m_sparseWeights == null) {
                    int n2 = instance.numValues();
                    for (int i = 0; i < n2; ++i) {
                        if (instance.index(i) == SMO.this.m_classIndex) continue;
                        d += this.m_weights[instance.index(i)] * instance.valueSparse(i);
                    }
                } else {
                    int n3 = instance.numValues();
                    int n4 = this.m_sparseWeights.length;
                    int n5 = 0;
                    int n6 = 0;
                    while (n5 < n3 && n6 < n4) {
                        int n7;
                        int n8 = instance.index(n5);
                        if (n8 == (n7 = this.m_sparseIndices[n6])) {
                            if (n8 != SMO.this.m_classIndex) {
                                d += instance.valueSparse(n5) * this.m_sparseWeights[n6];
                            }
                            ++n5;
                            ++n6;
                            continue;
                        }
                        if (n8 > n7) {
                            ++n6;
                            continue;
                        }
                        ++n5;
                    }
                }
            } else {
                int n9 = this.m_supportVectors.getNext(-1);
                while (n9 != -1) {
                    d += this.m_class[n9] * this.m_alpha[n9] * this.m_kernel.eval(n, n9, instance);
                    n9 = this.m_supportVectors.getNext(n9);
                }
            }
            return d -= this.m_b;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            if (this.m_alpha == null && this.m_sparseWeights == null) {
                return "BinarySMO: No model built yet.\n";
            }
            try {
                int n2;
                stringBuffer.append("BinarySMO\n\n");
                if (SMO.this.m_KernelIsLinear) {
                    stringBuffer.append("Machine linear: showing attribute weights, ");
                    stringBuffer.append("not support vectors.\n\n");
                    for (n2 = 0; n2 < this.m_sparseWeights.length; ++n2) {
                        if (this.m_sparseIndices[n2] == SMO.this.m_classIndex) continue;
                        if (n > 0) {
                            stringBuffer.append(" + ");
                        } else {
                            stringBuffer.append("   ");
                        }
                        stringBuffer.append(Utils.doubleToString(this.m_sparseWeights[n2], 12, 4) + " * ");
                        if (SMO.this.m_filterType == 1) {
                            stringBuffer.append("(standardized) ");
                        } else if (SMO.this.m_filterType == 0) {
                            stringBuffer.append("(normalized) ");
                        }
                        if (!SMO.this.m_checksTurnedOff) {
                            stringBuffer.append(this.m_data.attribute(this.m_sparseIndices[n2]).name() + "\n");
                        } else {
                            stringBuffer.append("attribute with index " + this.m_sparseIndices[n2] + "\n");
                        }
                        ++n;
                    }
                } else {
                    for (n2 = 0; n2 < this.m_alpha.length; ++n2) {
                        if (!this.m_supportVectors.contains(n2)) continue;
                        double d = this.m_alpha[n2];
                        if (this.m_class[n2] == 1.0) {
                            if (n > 0) {
                                stringBuffer.append(" + ");
                            }
                        } else {
                            stringBuffer.append(" - ");
                        }
                        stringBuffer.append(Utils.doubleToString(d, 12, 4) + " * <");
                        for (int i = 0; i < this.m_data.numAttributes(); ++i) {
                            if (i != this.m_data.classIndex()) {
                                stringBuffer.append(this.m_data.instance(n2).toString(i));
                            }
                            if (i == this.m_data.numAttributes() - 1) continue;
                            stringBuffer.append(" ");
                        }
                        stringBuffer.append("> * X]\n");
                        ++n;
                    }
                }
                if (this.m_b > 0.0) {
                    stringBuffer.append(" - " + Utils.doubleToString(this.m_b, 12, 4));
                } else {
                    stringBuffer.append(" + " + Utils.doubleToString(-this.m_b, 12, 4));
                }
                if (!SMO.this.m_KernelIsLinear) {
                    stringBuffer.append("\n\nNumber of support vectors: " + this.m_supportVectors.numElements());
                }
                n2 = 0;
                int n3 = -1;
                if (this.m_kernel != null) {
                    n2 = this.m_kernel.numEvals();
                    n3 = this.m_kernel.numCacheHits();
                }
                stringBuffer.append("\n\nNumber of kernel evaluations: " + n2);
                if (n3 >= 0 && n2 > 0) {
                    double d = 1.0 - (double)n2 * 1.0 / (double)(n3 + n2);
                    stringBuffer.append(" (" + Utils.doubleToString(d * 100.0, 7, 3).trim() + "% cached)");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return "Can't print BinarySMO classifier.";
            }
            return stringBuffer.toString();
        }

        protected boolean examineExample(int n) throws Exception {
            double d;
            int n2 = -1;
            double d2 = this.m_class[n];
            if (this.m_I0.contains(n)) {
                d = this.m_errors[n];
            } else {
                this.m_errors[n] = d = this.SVMOutput(n, this.m_data.instance(n)) + this.m_b - d2;
                if ((this.m_I1.contains(n) || this.m_I2.contains(n)) && d < this.m_bUp) {
                    this.m_bUp = d;
                    this.m_iUp = n;
                } else if ((this.m_I3.contains(n) || this.m_I4.contains(n)) && d > this.m_bLow) {
                    this.m_bLow = d;
                    this.m_iLow = n;
                }
            }
            boolean bl = true;
            if ((this.m_I0.contains(n) || this.m_I1.contains(n) || this.m_I2.contains(n)) && this.m_bLow - d > 2.0 * SMO.this.m_tol) {
                bl = false;
                n2 = this.m_iLow;
            }
            if ((this.m_I0.contains(n) || this.m_I3.contains(n) || this.m_I4.contains(n)) && d - this.m_bUp > 2.0 * SMO.this.m_tol) {
                bl = false;
                n2 = this.m_iUp;
            }
            if (bl) {
                return false;
            }
            if (this.m_I0.contains(n)) {
                n2 = this.m_bLow - d > d - this.m_bUp ? this.m_iLow : this.m_iUp;
            }
            if (n2 == -1) {
                throw new Exception("This should never happen!");
            }
            return this.takeStep(n2, n, d);
        }

        protected boolean takeStep(int n, int n2, double d) throws Exception {
            double d2;
            double d3;
            double d4;
            double d5;
            double d6 = SMO.this.m_C * this.m_data.instance(n).weight();
            double d7 = SMO.this.m_C * this.m_data.instance(n2).weight();
            if (n == n2) {
                return false;
            }
            double d8 = this.m_alpha[n];
            double d9 = this.m_alpha[n2];
            double d10 = this.m_class[n];
            double d11 = this.m_class[n2];
            double d12 = this.m_errors[n];
            double d13 = d10 * d11;
            if (d10 != d11) {
                d5 = Math.max(0.0, d9 - d8);
                d4 = Math.min(d7, d6 + d9 - d8);
            } else {
                d5 = Math.max(0.0, d8 + d9 - d6);
                d4 = Math.min(d7, d8 + d9);
            }
            if (d5 >= d4) {
                return false;
            }
            double d14 = this.m_kernel.eval(n, n, this.m_data.instance(n));
            double d15 = this.m_kernel.eval(n, n2, this.m_data.instance(n));
            double d16 = 2.0 * d15 - d14 - (d3 = this.m_kernel.eval(n2, n2, this.m_data.instance(n2)));
            if (d16 < 0.0) {
                d2 = d9 - d11 * (d12 - d) / d16;
                if (d2 < d5) {
                    d2 = d5;
                } else if (d2 > d4) {
                    d2 = d4;
                }
            } else {
                double d17;
                double d18;
                double d19;
                double d20 = d8 + d13 * d9;
                double d21 = this.SVMOutput(n, this.m_data.instance(n));
                double d22 = d21 + this.m_b - d10 * d8 * d14 - d11 * d9 * d15;
                double d23 = d20 - d13 * d5 + d5 - 0.5 * d14 * (d20 - d13 * d5) * (d20 - d13 * d5) - 0.5 * d3 * d5 * d5 - d13 * d15 * (d20 - d13 * d5) * d5 - d10 * (d20 - d13 * d5) * d22 - d11 * d5 * (d19 = (d18 = this.SVMOutput(n2, this.m_data.instance(n2))) + this.m_b - d10 * d8 * d15 - d11 * d9 * d3);
                d2 = d23 > (d17 = d20 - d13 * d4 + d4 - 0.5 * d14 * (d20 - d13 * d4) * (d20 - d13 * d4) - 0.5 * d3 * d4 * d4 - d13 * d15 * (d20 - d13 * d4) * d4 - d10 * (d20 - d13 * d4) * d22 - d11 * d4 * d19) + SMO.this.m_eps ? d5 : (d23 < d17 - SMO.this.m_eps ? d4 : d9);
            }
            if (Math.abs(d2 - d9) < SMO.this.m_eps * (d2 + d9 + SMO.this.m_eps)) {
                return false;
            }
            if (d2 > d7 - m_Del * d7) {
                d2 = d7;
            } else if (d2 <= m_Del * d7) {
                d2 = 0.0;
            }
            double d24 = d8 + d13 * (d9 - d2);
            if (d24 > d6 - m_Del * d6) {
                d24 = d6;
            } else if (d24 <= m_Del * d6) {
                d24 = 0.0;
            }
            if (d24 > 0.0) {
                this.m_supportVectors.insert(n);
            } else {
                this.m_supportVectors.delete(n);
            }
            if (d24 > 0.0 && d24 < d6) {
                this.m_I0.insert(n);
            } else {
                this.m_I0.delete(n);
            }
            if (d10 == 1.0 && d24 == 0.0) {
                this.m_I1.insert(n);
            } else {
                this.m_I1.delete(n);
            }
            if (d10 == -1.0 && d24 == d6) {
                this.m_I2.insert(n);
            } else {
                this.m_I2.delete(n);
            }
            if (d10 == 1.0 && d24 == d6) {
                this.m_I3.insert(n);
            } else {
                this.m_I3.delete(n);
            }
            if (d10 == -1.0 && d24 == 0.0) {
                this.m_I4.insert(n);
            } else {
                this.m_I4.delete(n);
            }
            if (d2 > 0.0) {
                this.m_supportVectors.insert(n2);
            } else {
                this.m_supportVectors.delete(n2);
            }
            if (d2 > 0.0 && d2 < d7) {
                this.m_I0.insert(n2);
            } else {
                this.m_I0.delete(n2);
            }
            if (d11 == 1.0 && d2 == 0.0) {
                this.m_I1.insert(n2);
            } else {
                this.m_I1.delete(n2);
            }
            if (d11 == -1.0 && d2 == d7) {
                this.m_I2.insert(n2);
            } else {
                this.m_I2.delete(n2);
            }
            if (d11 == 1.0 && d2 == d7) {
                this.m_I3.insert(n2);
            } else {
                this.m_I3.delete(n2);
            }
            if (d11 == -1.0 && d2 == 0.0) {
                this.m_I4.insert(n2);
            } else {
                this.m_I4.delete(n2);
            }
            if (SMO.this.m_KernelIsLinear) {
                Instance instance = this.m_data.instance(n);
                for (int i = 0; i < instance.numValues(); ++i) {
                    if (instance.index(i) == this.m_data.classIndex()) continue;
                    int n3 = instance.index(i);
                    this.m_weights[n3] = this.m_weights[n3] + d10 * (d24 - d8) * instance.valueSparse(i);
                }
                Instance instance2 = this.m_data.instance(n2);
                for (int i = 0; i < instance2.numValues(); ++i) {
                    if (instance2.index(i) == this.m_data.classIndex()) continue;
                    int n4 = instance2.index(i);
                    this.m_weights[n4] = this.m_weights[n4] + d11 * (d2 - d9) * instance2.valueSparse(i);
                }
            }
            int n5 = this.m_I0.getNext(-1);
            while (n5 != -1) {
                if (n5 != n && n5 != n2) {
                    int n6 = n5;
                    this.m_errors[n6] = this.m_errors[n6] + (d10 * (d24 - d8) * this.m_kernel.eval(n, n5, this.m_data.instance(n)) + d11 * (d2 - d9) * this.m_kernel.eval(n2, n5, this.m_data.instance(n2)));
                }
                n5 = this.m_I0.getNext(n5);
            }
            int n7 = n;
            this.m_errors[n7] = this.m_errors[n7] + (d10 * (d24 - d8) * d14 + d11 * (d2 - d9) * d15);
            int n8 = n2;
            this.m_errors[n8] = this.m_errors[n8] + (d10 * (d24 - d8) * d15 + d11 * (d2 - d9) * d3);
            this.m_alpha[n] = d24;
            this.m_alpha[n2] = d2;
            this.m_bLow = -1.7976931348623157E308;
            this.m_bUp = Double.MAX_VALUE;
            this.m_iLow = -1;
            this.m_iUp = -1;
            n5 = this.m_I0.getNext(-1);
            while (n5 != -1) {
                if (this.m_errors[n5] < this.m_bUp) {
                    this.m_bUp = this.m_errors[n5];
                    this.m_iUp = n5;
                }
                if (this.m_errors[n5] > this.m_bLow) {
                    this.m_bLow = this.m_errors[n5];
                    this.m_iLow = n5;
                }
                n5 = this.m_I0.getNext(n5);
            }
            if (!this.m_I0.contains(n)) {
                if (this.m_I3.contains(n) || this.m_I4.contains(n)) {
                    if (this.m_errors[n] > this.m_bLow) {
                        this.m_bLow = this.m_errors[n];
                        this.m_iLow = n;
                    }
                } else if (this.m_errors[n] < this.m_bUp) {
                    this.m_bUp = this.m_errors[n];
                    this.m_iUp = n;
                }
            }
            if (!this.m_I0.contains(n2)) {
                if (this.m_I3.contains(n2) || this.m_I4.contains(n2)) {
                    if (this.m_errors[n2] > this.m_bLow) {
                        this.m_bLow = this.m_errors[n2];
                        this.m_iLow = n2;
                    }
                } else if (this.m_errors[n2] < this.m_bUp) {
                    this.m_bUp = this.m_errors[n2];
                    this.m_iUp = n2;
                }
            }
            if (this.m_iLow == -1 || this.m_iUp == -1) {
                throw new Exception("This should never happen!");
            }
            return true;
        }

        protected void checkClassifier() throws Exception {
            int n;
            double d = 0.0;
            for (n = 0; n < this.m_alpha.length; ++n) {
                if (!(this.m_alpha[n] > 0.0)) continue;
                d += this.m_class[n] * this.m_alpha[n];
            }
            System.err.println("Sum of y(i) * alpha(i): " + d);
            for (n = 0; n < this.m_alpha.length; ++n) {
                double d2 = this.SVMOutput(n, this.m_data.instance(n));
                if (Utils.eq(this.m_alpha[n], 0.0) && Utils.sm(this.m_class[n] * d2, 1.0)) {
                    System.err.println("KKT condition 1 violated: " + this.m_class[n] * d2);
                }
                if (Utils.gr(this.m_alpha[n], 0.0) && Utils.sm(this.m_alpha[n], SMO.this.m_C * this.m_data.instance(n).weight()) && !Utils.eq(this.m_class[n] * d2, 1.0)) {
                    System.err.println("KKT condition 2 violated: " + this.m_class[n] * d2);
                }
                if (!Utils.eq(this.m_alpha[n], SMO.this.m_C * this.m_data.instance(n).weight()) || !Utils.gr(this.m_class[n] * d2, 1.0)) continue;
                System.err.println("KKT condition 3 violated: " + this.m_class[n] * d2);
            }
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 1.69 $");
        }
    }
}

