/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators;

import java.util.Random;
import java.util.Vector;
import weka.core.Matrix;
import weka.core.Utils;
import weka.estimators.ConditionalEstimator;
import weka.estimators.Estimator;
import weka.estimators.MahalanobisEstimator;

public class NNConditionalEstimator
implements ConditionalEstimator {
    private Vector m_Values = new Vector();
    private Vector m_CondValues = new Vector();
    private Vector m_Weights = new Vector();
    private double m_SumOfWeights;
    private double m_CondMean;
    private double m_ValueMean;
    private Matrix m_Covariance;
    private boolean m_AllWeightsOne = true;
    private static double TWO_PI = Math.PI * 2;

    private int findNearestPair(double d, double d2) {
        int n = 0;
        int n2 = this.m_CondValues.size();
        int n3 = 0;
        while (n < n2) {
            n3 = (n + n2) / 2;
            double d3 = (Double)this.m_CondValues.elementAt(n3);
            if (d3 == d) {
                double d4 = (Double)this.m_Values.elementAt(n3);
                if (d4 == d2) {
                    return n3;
                }
                if (d4 > d2) {
                    n2 = n3;
                } else if (d4 < d2) {
                    n = n3 + 1;
                }
            }
            if (d3 > d) {
                n2 = n3;
                continue;
            }
            if (!(d3 < d)) continue;
            n = n3 + 1;
        }
        return n;
    }

    private void calculateCovariance() {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.m_Values.size(); ++i) {
            d += (Double)this.m_Values.elementAt(i) * (Double)this.m_Weights.elementAt(i);
            d2 += (Double)this.m_CondValues.elementAt(i) * (Double)this.m_Weights.elementAt(i);
        }
        this.m_ValueMean = d / this.m_SumOfWeights;
        this.m_CondMean = d2 / this.m_SumOfWeights;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        for (int i = 0; i < this.m_Values.size(); ++i) {
            double d7 = (Double)this.m_Values.elementAt(i);
            double d8 = (Double)this.m_CondValues.elementAt(i);
            double d9 = (Double)this.m_Weights.elementAt(i);
            d3 += (d7 - this.m_ValueMean) * (d7 - this.m_ValueMean) * d9;
            d4 += (d7 - this.m_ValueMean) * (d8 - this.m_CondMean) * d9;
            d6 += (d8 - this.m_CondMean) * (d8 - this.m_CondMean) * d9;
        }
        d5 = d4 /= this.m_SumOfWeights - 1.0;
        this.m_Covariance = new Matrix(2, 2);
        this.m_Covariance.setElement(0, 0, d3 /= this.m_SumOfWeights - 1.0);
        this.m_Covariance.setElement(0, 1, d4);
        this.m_Covariance.setElement(1, 0, d5);
        this.m_Covariance.setElement(1, 1, d6 /= this.m_SumOfWeights - 1.0);
    }

    private double normalKernel(double d, double d2) {
        return Math.exp(-d * d / (2.0 * d2)) / Math.sqrt(d2 * TWO_PI);
    }

    public void addValue(double d, double d2, double d3) {
        int n = this.findNearestPair(d2, d);
        if (this.m_Values.size() <= n || (Double)this.m_CondValues.elementAt(n) != d2 || (Double)this.m_Values.elementAt(n) != d) {
            this.m_CondValues.insertElementAt(new Double(d2), n);
            this.m_Values.insertElementAt(new Double(d), n);
            this.m_Weights.insertElementAt(new Double(d3), n);
            if (d3 != 1.0) {
                this.m_AllWeightsOne = false;
            }
        } else {
            double d4 = (Double)this.m_Weights.elementAt(n);
            this.m_Weights.setElementAt(new Double(d4 += d3), n);
            this.m_AllWeightsOne = false;
        }
        this.m_SumOfWeights += d3;
        this.m_Covariance = null;
    }

    public Estimator getEstimator(double d) {
        if (this.m_Covariance == null) {
            this.calculateCovariance();
        }
        MahalanobisEstimator mahalanobisEstimator = new MahalanobisEstimator(this.m_Covariance, d - this.m_CondMean, this.m_ValueMean);
        return mahalanobisEstimator;
    }

    public double getProbability(double d, double d2) {
        return this.getEstimator(d2).getProbability(d);
    }

    public String toString() {
        if (this.m_Covariance == null) {
            this.calculateCovariance();
        }
        String string = "NN Conditional Estimator. " + this.m_CondValues.size() + " data points.  Mean = " + Utils.doubleToString(this.m_ValueMean, 4, 2) + "  Conditional mean = " + Utils.doubleToString(this.m_CondMean, 4, 2);
        string = string + "  Covariance Matrix: \n" + this.m_Covariance;
        return string;
    }

    public static void main(String[] stringArray) {
        try {
            int n;
            int n2;
            int n3 = 42;
            if (stringArray.length > 0) {
                n3 = Integer.parseInt(stringArray[0]);
            }
            NNConditionalEstimator nNConditionalEstimator = new NNConditionalEstimator();
            Random random = new Random(n3);
            int n4 = 50;
            if (stringArray.length > 2) {
                n4 = Integer.parseInt(stringArray[2]);
            }
            for (n2 = 0; n2 < n4; ++n2) {
                int n5 = Math.abs(random.nextInt() % 100);
                n = Math.abs(random.nextInt() % 100);
                System.out.println("# " + n5 + "  " + n);
                nNConditionalEstimator.addValue(n5, n, 1.0);
            }
            n2 = stringArray.length > 1 ? Integer.parseInt(stringArray[1]) : Math.abs(random.nextInt() % 100);
            System.out.println("## Conditional = " + n2);
            Estimator estimator = nNConditionalEstimator.getEstimator(n2);
            for (n = 0; n <= 100; n += 5) {
                System.out.println(" " + n + "  " + estimator.getProbability(n));
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

