/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.Sourcable;
import weka.classifiers.trees.j48.BinC45ModelSelection;
import weka.classifiers.trees.j48.C45ModelSelection;
import weka.classifiers.trees.j48.C45PruneableClassifierTree;
import weka.classifiers.trees.j48.ClassifierTree;
import weka.classifiers.trees.j48.ModelSelection;
import weka.classifiers.trees.j48.PruneableClassifierTree;
import weka.core.AdditionalMeasureProducer;
import weka.core.Capabilities;
import weka.core.Drawable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Matchable;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Summarizable;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class J48
extends Classifier
implements OptionHandler,
Drawable,
Matchable,
Sourcable,
WeightedInstancesHandler,
Summarizable,
AdditionalMeasureProducer,
TechnicalInformationHandler {
    static final long serialVersionUID = -217733168393644444L;
    private ClassifierTree m_root;
    private boolean m_unpruned = false;
    private float m_CF = 0.25f;
    private int m_minNumObj = 2;
    private boolean m_useLaplace = false;
    private boolean m_reducedErrorPruning = false;
    private int m_numFolds = 3;
    private boolean m_binarySplits = false;
    private boolean m_subtreeRaising = true;
    private boolean m_noCleanup = false;
    private int m_Seed = 1;

    public String globalInfo() {
        return "Class for generating a pruned or unpruned C4.5 decision tree. For more information, see\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.BOOK);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Ross Quinlan");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1993");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "C4.5: Programs for Machine Learning");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "Morgan Kaufmann Publishers");
        technicalInformation.setValue(TechnicalInformation.Field.ADDRESS, "San Mateo, CA");
        return technicalInformation;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities;
        try {
            capabilities = !this.m_reducedErrorPruning ? new C45PruneableClassifierTree(null, !this.m_unpruned, this.m_CF, this.m_subtreeRaising, !this.m_noCleanup).getCapabilities() : new PruneableClassifierTree(null, !this.m_unpruned, this.m_numFolds, !this.m_noCleanup, this.m_Seed).getCapabilities();
        }
        catch (Exception exception) {
            capabilities = new Capabilities(this);
        }
        capabilities.setOwner(this);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        ModelSelection modelSelection = this.m_binarySplits ? new BinC45ModelSelection(this.m_minNumObj, instances) : new C45ModelSelection(this.m_minNumObj, instances);
        this.m_root = !this.m_reducedErrorPruning ? new C45PruneableClassifierTree(modelSelection, !this.m_unpruned, this.m_CF, this.m_subtreeRaising, !this.m_noCleanup) : new PruneableClassifierTree(modelSelection, !this.m_unpruned, this.m_numFolds, !this.m_noCleanup, this.m_Seed);
        this.m_root.buildClassifier(instances);
        if (this.m_binarySplits) {
            ((BinC45ModelSelection)modelSelection).cleanup();
        } else {
            ((C45ModelSelection)modelSelection).cleanup();
        }
    }

    public double classifyInstance(Instance instance) throws Exception {
        return this.m_root.classifyInstance(instance);
    }

    public final double[] distributionForInstance(Instance instance) throws Exception {
        return this.m_root.distributionForInstance(instance, this.m_useLaplace);
    }

    public int graphType() {
        return 1;
    }

    public String graph() throws Exception {
        return this.m_root.graph();
    }

    public String prefix() throws Exception {
        return this.m_root.prefix();
    }

    public String toSource(String string) throws Exception {
        StringBuffer[] stringBufferArray = this.m_root.toSource(string);
        return "class " + string + " {\n\n" + "  public static double classify(Object [] i)\n" + "    throws Exception {\n\n" + "    double p = Double.NaN;\n" + stringBufferArray[0] + "    return p;\n" + "  }\n" + stringBufferArray[1] + "}\n";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(9);
        vector.addElement(new Option("\tUse unpruned tree.", "U", 0, "-U"));
        vector.addElement(new Option("\tSet confidence threshold for pruning.\n\t(default 0.25)", "C", 1, "-C <pruning confidence>"));
        vector.addElement(new Option("\tSet minimum number of instances per leaf.\n\t(default 2)", "M", 1, "-M <minimum number of instances>"));
        vector.addElement(new Option("\tUse reduced error pruning.", "R", 0, "-R"));
        vector.addElement(new Option("\tSet number of folds for reduced error\n\tpruning. One fold is used as pruning set.\n\t(default 3)", "N", 1, "-N <number of folds>"));
        vector.addElement(new Option("\tUse binary splits only.", "B", 0, "-B"));
        vector.addElement(new Option("\tDon't perform subtree raising.", "S", 0, "-S"));
        vector.addElement(new Option("\tDo not clean up after the tree has been built.", "L", 0, "-L"));
        vector.addElement(new Option("\tLaplace smoothing for predicted probabilities.", "A", 0, "-A"));
        vector.addElement(new Option("\tSeed for random data shuffling (default 1).", "Q", 1, "-Q <seed>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string;
        String string2 = Utils.getOption('M', stringArray);
        this.m_minNumObj = string2.length() != 0 ? Integer.parseInt(string2) : 2;
        this.m_binarySplits = Utils.getFlag('B', stringArray);
        this.m_useLaplace = Utils.getFlag('A', stringArray);
        this.m_unpruned = Utils.getFlag('U', stringArray);
        this.m_subtreeRaising = !Utils.getFlag('S', stringArray);
        this.m_noCleanup = Utils.getFlag('L', stringArray);
        if (this.m_unpruned && !this.m_subtreeRaising) {
            throw new Exception("Subtree raising doesn't need to be unset for unpruned tree!");
        }
        this.m_reducedErrorPruning = Utils.getFlag('R', stringArray);
        if (this.m_unpruned && this.m_reducedErrorPruning) {
            throw new Exception("Unpruned tree and reduced error pruning can't be selected simultaneously!");
        }
        String string3 = Utils.getOption('C', stringArray);
        if (string3.length() != 0) {
            if (this.m_reducedErrorPruning) {
                throw new Exception("Setting the confidence doesn't make sense for reduced error pruning.");
            }
            if (this.m_unpruned) {
                throw new Exception("Doesn't make sense to change confidence for unpruned tree!");
            }
            this.m_CF = new Float(string3).floatValue();
            if (this.m_CF <= 0.0f || this.m_CF >= 1.0f) {
                throw new Exception("Confidence has to be greater than zero and smaller than one!");
            }
        } else {
            this.m_CF = 0.25f;
        }
        if ((string = Utils.getOption('N', stringArray)).length() != 0) {
            if (!this.m_reducedErrorPruning) {
                throw new Exception("Setting the number of folds doesn't make sense if reduced error pruning is not selected.");
            }
            this.m_numFolds = Integer.parseInt(string);
        } else {
            this.m_numFolds = 3;
        }
        String string4 = Utils.getOption('Q', stringArray);
        this.m_Seed = string4.length() != 0 ? Integer.parseInt(string4) : 1;
    }

    public String[] getOptions() {
        String[] stringArray = new String[14];
        int n = 0;
        if (this.m_noCleanup) {
            stringArray[n++] = "-L";
        }
        if (this.m_unpruned) {
            stringArray[n++] = "-U";
        } else {
            if (!this.m_subtreeRaising) {
                stringArray[n++] = "-S";
            }
            if (this.m_reducedErrorPruning) {
                stringArray[n++] = "-R";
                stringArray[n++] = "-N";
                stringArray[n++] = "" + this.m_numFolds;
                stringArray[n++] = "-Q";
                stringArray[n++] = "" + this.m_Seed;
            } else {
                stringArray[n++] = "-C";
                stringArray[n++] = "" + this.m_CF;
            }
        }
        if (this.m_binarySplits) {
            stringArray[n++] = "-B";
        }
        stringArray[n++] = "-M";
        stringArray[n++] = "" + this.m_minNumObj;
        if (this.m_useLaplace) {
            stringArray[n++] = "-A";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String seedTipText() {
        return "The seed used for randomizing the data when reduced-error pruning is used.";
    }

    public int getSeed() {
        return this.m_Seed;
    }

    public void setSeed(int n) {
        this.m_Seed = n;
    }

    public String useLaplaceTipText() {
        return "Whether counts at leaves are smoothed based on Laplace.";
    }

    public boolean getUseLaplace() {
        return this.m_useLaplace;
    }

    public void setUseLaplace(boolean bl) {
        this.m_useLaplace = bl;
    }

    public String toString() {
        if (this.m_root == null) {
            return "No classifier built";
        }
        if (this.m_unpruned) {
            return "J48 unpruned tree\n------------------\n" + this.m_root.toString();
        }
        return "J48 pruned tree\n------------------\n" + this.m_root.toString();
    }

    public String toSummaryString() {
        return "Number of leaves: " + this.m_root.numLeaves() + "\n" + "Size of the tree: " + this.m_root.numNodes() + "\n";
    }

    public double measureTreeSize() {
        return this.m_root.numNodes();
    }

    public double measureNumLeaves() {
        return this.m_root.numLeaves();
    }

    public double measureNumRules() {
        return this.m_root.numLeaves();
    }

    public Enumeration enumerateMeasures() {
        Vector<String> vector = new Vector<String>(3);
        vector.addElement("measureTreeSize");
        vector.addElement("measureNumLeaves");
        vector.addElement("measureNumRules");
        return vector.elements();
    }

    public double getMeasure(String string) {
        if (string.compareToIgnoreCase("measureNumRules") == 0) {
            return this.measureNumRules();
        }
        if (string.compareToIgnoreCase("measureTreeSize") == 0) {
            return this.measureTreeSize();
        }
        if (string.compareToIgnoreCase("measureNumLeaves") == 0) {
            return this.measureNumLeaves();
        }
        throw new IllegalArgumentException(string + " not supported (j48)");
    }

    public String unprunedTipText() {
        return "Whether pruning is performed.";
    }

    public boolean getUnpruned() {
        return this.m_unpruned;
    }

    public void setUnpruned(boolean bl) {
        if (bl) {
            this.m_reducedErrorPruning = false;
        }
        this.m_unpruned = bl;
    }

    public String confidenceFactorTipText() {
        return "The confidence factor used for pruning (smaller values incur more pruning).";
    }

    public float getConfidenceFactor() {
        return this.m_CF;
    }

    public void setConfidenceFactor(float f) {
        this.m_CF = f;
    }

    public String minNumObjTipText() {
        return "The minimum number of instances per leaf.";
    }

    public int getMinNumObj() {
        return this.m_minNumObj;
    }

    public void setMinNumObj(int n) {
        this.m_minNumObj = n;
    }

    public String reducedErrorPruningTipText() {
        return "Whether reduced-error pruning is used instead of C.4.5 pruning.";
    }

    public boolean getReducedErrorPruning() {
        return this.m_reducedErrorPruning;
    }

    public void setReducedErrorPruning(boolean bl) {
        if (bl) {
            this.m_unpruned = false;
        }
        this.m_reducedErrorPruning = bl;
    }

    public String numFoldsTipText() {
        return "Determines the amount of data used for reduced-error pruning.  One fold is used for pruning, the rest for growing the tree.";
    }

    public int getNumFolds() {
        return this.m_numFolds;
    }

    public void setNumFolds(int n) {
        this.m_numFolds = n;
    }

    public String binarySplitsTipText() {
        return "Whether to use binary splits on nominal attributes when building the trees.";
    }

    public boolean getBinarySplits() {
        return this.m_binarySplits;
    }

    public void setBinarySplits(boolean bl) {
        this.m_binarySplits = bl;
    }

    public String subtreeRaisingTipText() {
        return "Whether to consider the subtree raising operation when pruning.";
    }

    public boolean getSubtreeRaising() {
        return this.m_subtreeRaising;
    }

    public void setSubtreeRaising(boolean bl) {
        this.m_subtreeRaising = bl;
    }

    public String saveInstanceDataTipText() {
        return "Whether to save the training data for visualization.";
    }

    public boolean getSaveInstanceData() {
        return this.m_noCleanup;
    }

    public void setSaveInstanceData(boolean bl) {
        this.m_noCleanup = bl;
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new J48(), stringArray));
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }
}

