/*
 * Decompiled with CFR 0.152.
 */
package weka.datagenerators.classifiers.classification;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Utils;
import weka.datagenerators.ClassificationGenerator;
import weka.datagenerators.DataGenerator;

public class RandomRBF
extends ClassificationGenerator {
    protected int m_NumAttributes;
    protected int m_NumClasses;
    protected int m_NumCentroids;
    protected double[][] m_centroids;
    protected int[] m_centroidClasses;
    protected double[] m_centroidWeights;
    protected double[] m_centroidStdDevs;

    public RandomRBF() {
        this.setNumAttributes(this.defaultNumAttributes());
        this.setNumClasses(this.defaultNumClasses());
        this.setNumCentroids(this.defaultNumCentroids());
    }

    public String globalInfo() {
        return "RandomRBF data is generated by first creating a random set of centers for each class. Each center is randomly assigned a weight, a central point per attribute, and a standard deviation. To generate new instances, a center is chosen at random taking the weights of each center into consideration. Attribute values are randomly generated and offset from the center, where the overall vector has been scaled so that its length equals a value sampled randomly from the Gaussian distribution of the center. The particular center chosen determines the class of the instance.\n RandomRBF data contains only numeric attributes as it is non-trivial to include nominal values.";
    }

    public Enumeration listOptions() {
        Vector vector = this.enumToVector(super.listOptions());
        vector.addElement(new Option("\tThe number of attributes (default " + this.defaultNumAttributes() + ").", "a", 1, "-a <num>"));
        vector.addElement(new Option("\tThe number of classes (default " + this.defaultNumClasses() + ")", "c", 1, "-c <num>"));
        vector.add(new Option("\tThe number of centroids to use. (default " + this.defaultNumCentroids() + ")", "C", 1, "-C <num>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
        String string = Utils.getOption('a', stringArray);
        if (string.length() != 0) {
            this.setNumAttributes(Integer.parseInt(string));
        } else {
            this.setNumAttributes(this.defaultNumAttributes());
        }
        string = Utils.getOption('c', stringArray);
        if (string.length() != 0) {
            this.setNumClasses(Integer.parseInt(string));
        } else {
            this.setNumClasses(this.defaultNumClasses());
        }
        string = Utils.getOption('C', stringArray);
        if (string.length() != 0) {
            this.setNumCentroids(Integer.parseInt(string));
        } else {
            this.setNumCentroids(this.defaultNumCentroids());
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        vector.add("-a");
        vector.add("" + this.getNumAttributes());
        vector.add("-c");
        vector.add("" + this.getNumClasses());
        vector.add("-C");
        vector.add("" + this.getNumCentroids());
        return vector.toArray(new String[vector.size()]);
    }

    protected int defaultNumAttributes() {
        return 10;
    }

    public void setNumAttributes(int n) {
        this.m_NumAttributes = n;
    }

    public int getNumAttributes() {
        return this.m_NumAttributes;
    }

    public String numAttributesTipText() {
        return "The number of attributes the generated data will contain.";
    }

    protected int defaultNumClasses() {
        return 2;
    }

    public void setNumClasses(int n) {
        this.m_NumClasses = n;
    }

    public int getNumClasses() {
        return this.m_NumClasses;
    }

    public String numClassesTipText() {
        return "The number of classes to generate.";
    }

    protected int defaultNumCentroids() {
        return 50;
    }

    public int getNumCentroids() {
        return this.m_NumCentroids;
    }

    public void setNumCentroids(int n) {
        if (n > 0) {
            this.m_NumCentroids = n;
        } else {
            System.out.println("At least 1 centroid is necessary (provided: " + n + ")!");
        }
    }

    public String numCentroidsTipText() {
        return "The number of centroids to use.";
    }

    public boolean getSingleModeFlag() throws Exception {
        return true;
    }

    protected int chooseRandomIndexBasedOnProportions(double[] dArray, Random random) {
        double d = Utils.sum(dArray);
        double d2 = random.nextDouble() * d;
        int n = 0;
        for (double d3 = 0.0; d3 <= d2 && n < dArray.length; d3 += dArray[n++]) {
        }
        return n - 1;
    }

    public Instances defineDataFormat() throws Exception {
        int n;
        this.m_Random = new Random(this.getSeed());
        Random random = this.getRandom();
        this.setNumExamplesAct(this.getNumExamples());
        this.m_centroids = new double[this.getNumCentroids()][this.getNumAttributes()];
        this.m_centroidClasses = new int[this.getNumCentroids()];
        this.m_centroidWeights = new double[this.getNumCentroids()];
        this.m_centroidStdDevs = new double[this.getNumCentroids()];
        for (n = 0; n < this.getNumCentroids(); ++n) {
            for (int i = 0; i < this.getNumAttributes(); ++i) {
                this.m_centroids[n][i] = random.nextDouble();
            }
            this.m_centroidClasses[n] = random.nextInt(this.getNumClasses());
            this.m_centroidWeights[n] = random.nextDouble();
            this.m_centroidStdDevs[n] = random.nextDouble();
        }
        FastVector fastVector = new FastVector();
        for (n = 0; n < this.getNumAttributes(); ++n) {
            fastVector.addElement(new Attribute("a" + n));
        }
        FastVector fastVector2 = new FastVector();
        for (n = 0; n < this.getNumClasses(); ++n) {
            fastVector2.addElement("c" + n);
        }
        fastVector.addElement(new Attribute("class", fastVector2));
        this.m_DatasetFormat = new Instances(this.getRelationNameToUse(), fastVector, 0);
        return this.m_DatasetFormat;
    }

    public Instance generateExample() throws Exception {
        int n;
        Instance instance = null;
        Random random = this.getRandom();
        if (this.m_DatasetFormat == null) {
            throw new Exception("Dataset format not defined.");
        }
        int n2 = this.chooseRandomIndexBasedOnProportions(this.m_centroidWeights, random);
        double d = this.m_centroidClasses[n2];
        double[] dArray = new double[this.getNumAttributes() + 1];
        for (n = 0; n < this.getNumAttributes(); ++n) {
            dArray[n] = random.nextDouble() * 2.0 - 1.0;
        }
        dArray[dArray.length - 1] = d;
        double d2 = 0.0;
        for (n = 0; n < this.getNumAttributes(); ++n) {
            d2 += dArray[n] * dArray[n];
        }
        d2 = Math.sqrt(d2);
        double d3 = random.nextGaussian() * this.m_centroidStdDevs[n2];
        double d4 = d3 / d2;
        for (n = 0; n < this.getNumAttributes(); ++n) {
            int n3 = n;
            dArray[n3] = dArray[n3] * d4;
            int n4 = n;
            dArray[n4] = dArray[n4] + this.m_centroids[n2][n];
            instance = new Instance(1.0, dArray);
        }
        instance.setDataset(this.m_DatasetFormat);
        return instance;
    }

    public Instances generateExamples() throws Exception {
        Instances instances = new Instances(this.m_DatasetFormat, 0);
        this.m_Random = new Random(this.getSeed());
        for (int i = 0; i < this.getNumExamplesAct(); ++i) {
            instances.add(this.generateExample());
        }
        return instances;
    }

    public String generateStart() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("%\n");
        stringBuffer.append("% centroids:\n");
        for (int i = 0; i < this.getNumCentroids(); ++i) {
            stringBuffer.append("% " + i + ".: " + Utils.arrayToString(this.m_centroids[i]) + "\n");
        }
        stringBuffer.append("%\n");
        stringBuffer.append("% centroidClasses: " + Utils.arrayToString(this.m_centroidClasses) + "\n");
        stringBuffer.append("%\n");
        stringBuffer.append("% centroidWeights: " + Utils.arrayToString(this.m_centroidWeights) + "\n");
        stringBuffer.append("%\n");
        stringBuffer.append("% centroidStdDevs: " + Utils.arrayToString(this.m_centroidStdDevs) + "\n");
        stringBuffer.append("%\n");
        return stringBuffer.toString();
    }

    public String generateFinished() throws Exception {
        return "";
    }

    public static void main(String[] stringArray) {
        try {
            DataGenerator.makeData(new RandomRBF(), stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception.getMessage());
        }
    }
}

