/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.SparseInstance;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;

public class FirstOrder
extends Filter
implements UnsupervisedFilter,
StreamableFilter,
OptionHandler {
    protected Range m_DeltaCols = new Range();

    public String globalInfo() {
        return "This instance filter takes a range of N numeric attributes and replaces them with N-1 numeric attributes, the values of which are the difference between consecutive attribute values from the original instance. eg: \n\nOriginal attribute values\n\n   0.1, 0.2, 0.3, 0.1, 0.3\n\nNew attribute values\n\n   0.1, 0.1, -0.2, 0.2\n\nThe range of attributes used is taken in numeric order. That is, a range spec of 7-11,3-5 will use the attribute ordering 3,4,5,7,8,9,10,11 for the differences, NOT 7,8,9,10,11,3,4,5.";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(1);
        vector.addElement(new Option("\tSpecify list of columns to take the differences between.\n\tFirst and last are valid indexes.\n\t(default none)", "R", 1, "-R <index1,index2-index4,...>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('R', stringArray);
        if (string.length() != 0) {
            this.setAttributeIndices(string);
        } else {
            this.setAttributeIndices("");
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[2];
        int n = 0;
        if (!this.getAttributeIndices().equals("")) {
            stringArray[n++] = "-R";
            stringArray[n++] = this.getAttributeIndices();
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        this.m_DeltaCols.setUpper(this.getInputFormat().numAttributes() - 1);
        int n = 0;
        for (int i = this.getInputFormat().numAttributes() - 1; i >= 0; --i) {
            if (!this.m_DeltaCols.isInRange(i)) continue;
            ++n;
            if (this.getInputFormat().attribute(i).isNumeric()) continue;
            throw new UnsupportedAttributeTypeException("Selected attributes must be all numeric");
        }
        if (n == 1) {
            throw new Exception("Cannot select only one attribute.");
        }
        FastVector fastVector = new FastVector();
        boolean bl = false;
        String string = null;
        for (int i = 0; i < instances.numAttributes(); ++i) {
            if (this.m_DeltaCols.isInRange(i)) {
                if (bl) {
                    Attribute attribute = new Attribute(string);
                    fastVector.addElement(attribute);
                }
                string = instances.attribute(i).name();
                string = "'FO " + string.replace('\'', ' ').trim() + '\'';
                bl = true;
                continue;
            }
            fastVector.addElement((Attribute)instances.attribute(i).copy());
        }
        this.setOutputFormat(new Instances(instances.relationName(), fastVector, 0));
        return true;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        Instances instances = this.outputFormatPeek();
        double[] dArray = new double[instances.numAttributes()];
        boolean bl = false;
        double d = Instance.missingValue();
        int n = 0;
        int n2 = 0;
        while (n2 < instances.numAttributes()) {
            if (this.m_DeltaCols.isInRange(n)) {
                if (bl) {
                    dArray[n2++] = Instance.isMissingValue(d) || instance.isMissing(n) ? Instance.missingValue() : instance.value(n) - d;
                } else {
                    bl = true;
                }
                d = instance.value(n);
            } else {
                dArray[n2++] = instance.value(n);
            }
            ++n;
        }
        Instance instance2 = null;
        instance2 = instance instanceof SparseInstance ? new SparseInstance(instance.weight(), dArray) : new Instance(instance.weight(), dArray);
        this.copyStringValues(instance2, false, instance.dataset(), this.getInputStringIndex(), this.getOutputFormat(), this.getOutputStringIndex());
        instance2.setDataset(this.getOutputFormat());
        this.push(instance2);
        return true;
    }

    public String attributeIndicesTipText() {
        return "Specify range of attributes to act on. This is a comma separated list of attribute indices, with \"first\" and \"last\" valid values. Specify an inclusive range with \"-\". E.g: \"first-3,5,6-10,last\".";
    }

    public String getAttributeIndices() {
        return this.m_DeltaCols.getRanges();
    }

    public void setAttributeIndices(String string) throws Exception {
        this.m_DeltaCols.setRanges(string);
    }

    public void setAttributeIndicesArray(int[] nArray) throws Exception {
        this.setAttributeIndices(Range.indicesToRangeList(nArray));
    }

    public static void main(String[] stringArray) {
        try {
            if (Utils.getFlag('b', stringArray)) {
                Filter.batchFilterFile(new FirstOrder(), stringArray);
            } else {
                Filter.filterFile(new FirstOrder(), stringArray);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

