/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.SingleIndex;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;

public class StringToNominal
extends Filter
implements UnsupervisedFilter,
OptionHandler {
    private SingleIndex m_AttIndex = new SingleIndex("last");

    public String globalInfo() {
        return "Converts a string attribute (i.e. unspecified number of values) to nominal (i.e. set number of values). You should ensure that all string values that will appear are represented in the first batch of the data.";
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        this.m_AttIndex.setUpper(instances.numAttributes() - 1);
        if (!instances.attribute(this.m_AttIndex.getIndex()).isString()) {
            throw new UnsupportedAttributeTypeException("Chosen attribute is not of type string.");
        }
        return false;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.isOutputFormatDefined()) {
            Instance instance2 = (Instance)instance.copy();
            this.push(instance2);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    public boolean batchFinished() {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (!this.isOutputFormatDefined()) {
            this.setOutputFormat();
            for (int i = 0; i < this.getInputFormat().numInstances(); ++i) {
                this.push((Instance)this.getInputFormat().instance(i).copy());
            }
        }
        this.flushInput();
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(1);
        vector.addElement(new Option("\tSets the attribute index (default last).", "C", 1, "-C <col>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('C', stringArray);
        if (string.length() != 0) {
            this.setAttributeIndex(string);
        } else {
            this.setAttributeIndex("last");
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[6];
        int n = 0;
        stringArray[n++] = "-C";
        stringArray[n++] = "" + this.getAttributeIndex();
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String attributeIndexTipText() {
        return "Sets which attribute to process. This attribute must be a string attribute (\"first\" and \"last\" are valid values)";
    }

    public String getAttributeIndex() {
        return this.m_AttIndex.getSingleIndex();
    }

    public void setAttributeIndex(String string) {
        this.m_AttIndex.setSingleIndex(string);
    }

    private void setOutputFormat() {
        FastVector fastVector = new FastVector(this.getInputFormat().numAttributes());
        for (int i = 0; i < this.getInputFormat().numAttributes(); ++i) {
            Attribute attribute = this.getInputFormat().attribute(i);
            if (i != this.m_AttIndex.getIndex()) {
                fastVector.addElement(attribute);
                continue;
            }
            FastVector fastVector2 = new FastVector(attribute.numValues());
            for (int j = 0; j < attribute.numValues(); ++j) {
                fastVector2.addElement(attribute.value(j));
            }
            fastVector.addElement(new Attribute(attribute.name(), fastVector2));
        }
        Instances instances = new Instances(this.getInputFormat().relationName(), fastVector, 0);
        instances.setClassIndex(this.getInputFormat().classIndex());
        this.setOutputFormat(instances);
    }

    public static void main(String[] stringArray) {
        try {
            if (Utils.getFlag('b', stringArray)) {
                Filter.batchFilterFile(new StringToNominal(), stringArray);
            } else {
                Filter.filterFile(new StringToNominal(), stringArray);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

