\name{val.resid}
\alias{val.resid}
\title{
Analyse graphique des residus d'un modele lineaire ou lineaire generalise
}
\description{
Permet d'observer graphiquement si les rsidus d'un modle repsectent les conditions d'quivariance et de normalit de distribution.
}
\usage{
val.resid(model, reg=FALSE, fact=NULL)
}
\arguments{
  \item{model}{
modle, de type \code{lm()} ou \code{glm()}.
}
  \item{reg}{
logique : \code{TRUE} si le modle est celui d'une rgression, \code{FALSE} si c'est celui d'une analyse de variance/dviance.
}
  \item{fact}{
si le modle est celui d'une analyse de variance/dviance, nom du facteur pour lequel on veut tracer le diagramme en botes  moustaches (entre guillemets).
}
}
\details{
Les rsidus sont obtenus \emph{via} la fonction \code{residuals()} si le modle est linaire ou linaire gnralis avec une loi continue (\code{gaussian}, \code{inverse.gaussian} ou \code{Gamma}), \emph{via} la fonction \code{qresiduals()} du package statmod si le modle est linaire gnralis avec une loi discontinue (\code{poisson}, \code{binomial}, \code{quasipoisson}, \code{quasibinomial} ou binomiale ngative \emph{via} la fonction \code{glm.nb()} du package MASS).
}
\author{
Maxime Herv
}
\seealso{
\code{\link{lm}}, \code{\link{glm}}, \code{\link{residuals}}, \code{\link[statmod]{qresiduals}}, \code{\link{qqnorm}}, \code{\link{boxplot}}
}
\examples{
# Regression
x<-1:30
y<-1:30+rnorm(30,0,2)
modele<-lm(y~x)
val.resid(modele,reg=TRUE)

# Analyse de variance
f<-factor(rep(LETTERS[1:3],each=10))
modele2<-lm(y~f)
val.resid(modele2,reg=FALSE,fact="f")
}
