\name{scat.mix.categorical}
\alias{scat.mix.categorical}
\title{
Representation des variables qualitatives en analyse mixte de Hill et Smith
}
\description{
Reprsente les variables qualitatives d'une analyse mixte de Hill et Smith  la manire d'une ACM.  La fonction est base sur la fonction \code{s.class()} du package ade4.
}
\usage{
scat.mix.categorical(dudi.obj, xax = 1, yax = 2, csub = 2, possub = "topleft", ...)
}
\arguments{
  \item{dudi.obj}{
objet contenant les rsultats de l'analyse, classiquement obtenue \emph{via} la fonction \code{dudi.mix()} du package ade4.
}
  \item{xax}{
axe  reprsenter horizontalement.
}
  \item{yax}{
axe  reprsenter verticalement.
}
  \item{csub}{
taille du titre de chaque graphe trac (le titre tant le nom de la variable reprsente).
}
  \item{possub}{
position du titre des graphes tracs (parmi \code{"topleft"}, \code{"topright"}, \code{"bottomleft"} et \code{"bottomright"})
}
  \item{\dots}{
arguments additionnels passs  la fonction \code{s.class()}. Voir l'aide de cette fonction.
}
}
\references{
Champely, S. 2005 Introduction  l'analyse multivarie (factorielle) sous R.
}
\author{
Maxime Herv, d'aprs Stphane Champely
}
\seealso{
\code{\link[ade4]{dudi.mix}}, \code{\link[ade4]{s.class}}
}
\examples{
# Jeu de donnees bidon
age<-sample(15:60,50,replace=TRUE)
sexe<-sample(c("M","F"),50,replace=TRUE)
taille<-sample(155:190,50,replace=TRUE)
cheveux<-sample(c("Blond","Brun","Roux"),50,replace=TRUE)
yeux<-sample(c("Bleu","Vert","Marron"),50,replace=TRUE)
poids<-sample(50:85,50,replace=TRUE)
cote<-sample(c("Gaucher","Droitier"),50,replace=TRUE)
tab<-data.frame(age,sexe,taille,poids,cote,yeux,cheveux)
amix<-dudi.mix(tab,scannf=FALSE,nf=2)
scat.mix.categorical(amix)
}
