\name{cor.multcomp}
\alias{cor.multcomp}
\title{
Comparaison de plusieurs coefficients de correlation lineaire de Pearson
}
\description{
Ralise le test de comparaison de plusieurs coefficients de corrlation linaire de Pearson.  S'il n'existe aucune diffrence significative, la fonction renvoie la valeur du coefficient de corrlation commun, son intervalle de confiance et ralise le test de conformit avec une valeur thorique choisie.  Dans le cas contraire, la fonction ralise toutes les comparaisons deux--deux possibles.
}
\usage{
cor.multcomp(var1, var2, fact, alpha = 0.05, conf.level = 0.95, r.arr = 4, theo = 0, p.method = "fdr", p.arr = 4)
}
\arguments{
  \item{var1}{
1re variable  corrler.
}
  \item{var2}{
2me variable  corrler.
}
  \item{fact}{
facteur dfinissant les groupes  comparer.
}
  \item{alpha}{
seuil de significativit du test global.
}
  \item{conf.level}{
intervalle de confiance du coefficient de corrlation commun.
}
  \item{r.arr}{
nombre de dcimales affiches des coefficients de corrlation.
}
  \item{theo}{
valeur thorique du test de conformit du coefficient de corrlation commun.
}
  \item{p.method}{
mthode de correction des \emph{p-values} pour les comparaisons multiples. Voir l'aide de la fonction \code{p.adjust()}.
}
  \item{p.arr}{
nombre de dcimales affiches des \emph{p-values} des tests raliss.
}
}
\author{
Maxime Herv
}
\seealso{
\code{\link{cor.test}}, \code{\link[gtools]{combinations}}, \code{\link{p.adjust}}
}
\examples{
# Test par defaut
var1<-c(1:15+rnorm(15,0,4),1:15+rnorm(15,0,1),1:15+rnorm(15,0,8))
var2<-c(-1:-15+rnorm(15,0,4),1:15+rnorm(15,0,1),1:15+rnorm(15,0,8))
facteur<-as.factor(rep(LETTERS[1:3],each=15))
cor.multcomp(var1,var2,facteur)

# Correction des p-values avec la methode de Bonferroni
cor.multcomp(var1,var2,facteur,p.method="bonferroni")
}