\name{bootstrap}
\alias{bootstrap}
\title{
  Bootstrap
}
\description{
Version simplifie de la fonction \code{boot()} du package boot.
}
\usage{
bootstrap(vect, fun, rep = 1000, conf.level = 0.95, arr = 4, ...)
}
\arguments{
  \item{vect}{
srie de donnes  partir de laquelle raliser le calcul.
}
  \item{fun}{
fonction ralisant le calcul souhait. Doit tre de la forme \code{function(x,i) ...(x[i])}.
}
  \item{rep}{
nombre de rptitions du bootstrap.
}
  \item{conf.level}{
intervalle de confiance souhait
}
  \item{arr}{
nombre de dcimales affiches de l'intervalle de confiance renvoy.
}
  \item{\dots}{
arguments additionnels passs  la fonction \code{boot()}. Voir l'aide de cette fonction.
}
}
\details{
L'argument utilis dans l'expression  calculer doit tre le mme que le premier dclar  \code{function} (ici \code{x}).  Cet argument doit tre suivi du second dclar  \code{function()} plac entre crochets. Celui-ci est par dfaut \code{i} (voir l'aide de la fonction \code{boot()}).
}
\author{
Maxime Herv
}
\seealso{
\code{\link[boot]{boot}}
}
\examples{
# Intervalle de confiance a 95 pc d'une moyenne sur petit echantillon
ech<-sample(1:50,10,replace=TRUE)
bootstrap(ech,function(x,i) mean(x[i]))

# La meme chose avec un intervalle de confiance a 99 pc
bootstrap(ech,function(x,i) mean(x[i]),conf.level=0.99)

# Un calcul (un peu) plux complexe, l'intervalle de confiance de l'erreur standard
# de la moyenne
bootstrap(ech,function(x,i) sd(x[i])/sqrt(length(x[i])))
}
