\name{create_precisionRecallSummary}
\alias{create_precisionRecallSummary}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
creates a summary with precision, recall, and F1 scores.
}
\description{
Creates a summary with precision, recall, and F1 scores for each algorithm broken down by unique label.
}
\usage{
create_precisionRecallSummary(container, classification_results, b_value = 1)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{container}{
Class of type \code{\link{matrix_container-class}} generated by the \code{\link{create_container}} function.
}
  \item{classification_results}{
A \code{cbind()} of result objects returned by \code{\link{classify_model}}, or the object returned by \code{\link{classify_models}}.
}
  \item{b_value}{
b-value for generating precision, recall, and F-scores statistics.
}
}
\author{
Loren Collingwood <lorenc2@uw.edu>, Timothy P. Jurka <tpjurka@ucdavis.edu>
}
\examples{
library(RTextTools)
data(NYTimes)
data <- NYTimes[sample(1:3100,size=100,replace=FALSE),]
matrix <- create_matrix(cbind(data["Title"],data["Subject"]), language="english", 
removeNumbers=TRUE, stemWords=FALSE, weighting=tm::weightTfIdf)
container <- create_container(matrix,data$Topic.Code,trainSize=1:75, testSize=76:100, 
virgin=FALSE)
models <- train_models(container, algorithms=c("MAXENT","SVM"))
results <- classify_models(container, models)
precision_recall_f1 <- create_precisionRecallSummary(container, results)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{method}
