\name{create_ensembleSummary}
\alias{create_ensembleSummary}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
creates a summary with ensemble coverage and precision.
}
\description{
Creates a summary with ensemble coverage and precision values for an ensemble greater than the threshold specified.
}
\usage{
create_ensembleSummary(document_summary, threshold)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{document_summary}{
The \code{document_summary} slot from the \code{\link{analytics_container-class}} generated by \code{\link{create_analytics}}.
}
  \item{threshold}{
The number of algorithms greater than or equal to this threshold that agree on the same topic. For example, a threshold value of 3 will search for those documents where 3 or more algorithms agreed.
}
}
\details{
This summary is created in the \code{\link{create_analytics}} function.  Note that a threshold value of 3 will return ensemble coverage and precision statistics for topic codes that had 3 or more (i.e. >=3) algorithms agree on the same topic code.
}
\author{
Loren Collingwood <lorenc2@uw.edu>, Timothy P. Jurka <tpjurka@ucdavis.edu>
}
\examples{
library(RTextTools)
data <- read_data(system.file("data/NYTimes.csv.gz",package="RTextTools"),type="csv")
data <- data[sample(1:3100,size=100,replace=FALSE),]
matrix <- create_matrix(cbind(data$Title,data$Subject), language="english", 
removeNumbers=TRUE, stemWords=FALSE, weighting=weightTfIdf)
corpus <- create_corpus(matrix,data$Topic.Code,trainSize=1:75, testSize=76:100, 
virgin=FALSE)
models <- train_models(corpus, algorithms=c("MAXENT","SVM"))
results <- classify_models(corpus, models)
analytics <- create_analytics(corpus, results)
ensemble <- create_ensembleSummary(analytics@document_summary,2)
ensemble
}
\keyword{method}
