% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.test.R
\name{test_returnValue_image}
\alias{test_returnValue_image}
\title{Tests an image file with ImageMagick ('RTestTest_image')}
\usage{
test_returnValue_image(result, reference, xmlTestSpec, add.desc = NULL)
}
\arguments{
\item{result}{(\code{object}) The result object to be tested.}

\item{reference}{(\code{object}) The reference object.}

\item{xmlTestSpec}{(\code{XMLNode}) The XML definition of type 'RTestTest_variable'.}

\item{add.desc}{(\code{character}) Additional description added to the XML 
definition.}
}
\description{
Tests an image file with ImageMagick ('RTestTest_image')
}
\examples{

# Cleaning up

tryCatch(unloadNamespace("RTest"))
tryCatch(unloadNamespace("testthat"))
library(RTest)

# create some definition of tests

data <- '<test_image desc="Compare a value" diff-type="relative" 
         compare-type="equal" tolerance="0"/>'
xmlTestSpec <- XML::xmlRoot(XML::xmlParse(data,asText=TRUE))
location <- find.package("RTest")

# Create a test with equal images

result <- paste0(location,"/images/Roche_Logo.png")
reference <- paste0(location,"/images/Roche_Logo.png")

test_returnValue_image(result,reference,xmlTestSpec)

 # Create a test with images that are not equal

reference <- paste0(location,"/images/Roche_Logo_defect.png")
tryCatch(
	test_returnValue_image(result,reference,xmlTestSpec),
	error=function(e){
		if(!grepl("not equal to",e)){
			stop("image omparison defect, please check code")
		}
	})
	
}
\seealso{
\code{\link[XML]{XMLNode-class}}
}
\author{
Sebastian Wolf \email{sebastian.wolf.sw1@roche.com}
}
