% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.test.R
\name{test_returnValue_variable}
\alias{test_returnValue_variable}
\title{Tests a Standard R 'variable' ('RTestTest_vector_variable')}
\usage{
test_returnValue_variable(result, reference, xmlTestSpec, add.desc = NULL)
}
\arguments{
\item{result}{(\code{object}) The result object to be tested.}

\item{reference}{(\code{object}) The reference object.}

\item{xmlTestSpec}{(\code{XMLNode}) The XML definition of type 'RTestTest_variable'.}

\item{add.desc}{(\code{character}) Additional description added to the XML 
definition.}
}
\description{
Tests a Standard R 'variable' ('RTestTest_vector_variable')
}
\examples{

# Cleaning up

tryCatch(unloadNamespace("RTest"))
tryCatch(unloadNamespace("testthat"))
library(RTest)

data <- '<test_variable desc="Compare a value" 
          diff-type="absolute" compare-type="equal" tolerance="1E-3"/>'
xmlTestSpec <- XML::xmlRoot(XML::xmlParse(data,asText=TRUE))

test_returnValue_variable(5,5,xmlTestSpec)

test_returnValue_variable(5.0001,5,xmlTestSpec)

# Compare variable with a stricter tolerance

data <- '<test_variable desc="Compare a value" 
          diff-type="relative" compare-type="equal" tolerance="1E-6"/>'
xmlTestSpec <- XML::xmlRoot(XML::xmlParse(data,asText=TRUE))

tryCatch(unloadNamespace("RTest"))
tryCatch(unloadNamespace("testthat"))
library(RTest)
 
tryCatch(
		test_returnValue_variable(5.0001,5,xmlTestSpec),error=function(e){
			stopifnot(grepl("5.0001 not equal to 5.",e))
		})

}
\seealso{
\code{\link[XML]{XMLNode-class}}
}
\author{
Matthias Pfeifer \email{matthias.pfeifer@roche.com}
}
