% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_eia_sd.R
\name{chart_eia_sd}
\alias{chart_eia_sd}
\title{\code{chart_eia_sd}}
\usage{
chart_eia_sd(
  market = "mogas",
  key = "your EIA.gov API key",
  from = "2011-01-01",
  legend.pos = list(x = 0.4, y = 0.53),
  output = "chart"
)
}
\arguments{
\item{market}{"mogas", "dist", "jet" or "resid".}

\item{key}{Your private EIA API token.}

\item{from}{Date as character "2020-07-01". Default to all dates available.}

\item{legend.pos}{Defaults to list(x = 0.4, y = 0.53)}

\item{output}{"chart" for plotly object or "data" for dataframe.}
}
\value{
A plotly object or a dataframe
}
\description{
Supply Demand Balance from EIA Short Term Energy Outlook.
}
\examples{
\dontrun{
chart_eia_sd(key = key, market = "mogas")
 }
}
\author{
Philippe Cote
}
