% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetFile.R
\name{GetFile}
\alias{GetFile}
\title{GUI: Select File to Open or Save As}
\usage{
GetFile(cmd = c("Open", "Save As"), file = NULL, exts = NULL,
  initialdir = NULL, initialfile = NULL, defaultextension = NULL,
  win.title = cmd, multi = FALSE, parent = NULL)
}
\arguments{
\item{cmd}{character.
Specifies whether an \code{"Open"} or \code{"Save As"} file management pop up dialog box is implemented.}

\item{file}{character.
File name that the data are to be read from.
Alternatively, \code{file} can be a readable text-mode \code{\link{connection}}.}

\item{exts}{character.
Vector of default file extensions.}

\item{initialdir}{character.
Files in this directory will be displayed in the dialog box.}

\item{initialfile}{character.
File name to display in the dialog box.}

\item{defaultextension}{character.
String appended to the file name if the user enters a file name without an extension.}

\item{win.title}{character.
String to display as the title of the dialog box.}

\item{multi}{logical.
If true, multiple files may be selected.}

\item{parent}{tkwin.
\acronym{GUI} parent window}
}
\value{
If \code{multi} is false, returns the file path as a character object with the following attributes:
  \item{directory}{directory containing the file}
  \item{name}{file name}
  \item{extension}{file extension}
  \item{type}{file type}
  Otherwise, a list is returned containing a object of class character for each file.
}
\description{
A graphical user interface (\acronym{GUI}) for selecting files to open or save.
}
\examples{
\dontrun{
  GetFile()
}

}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{file}
