% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sse_rb2stage.R
\name{sse.rb.2stage}
\alias{sse.rb.2stage}
\title{Two-stage risk-based system sensitivity}
\usage{
sse.rb.2stage(C = NA, pstar.c, pstar.u, rr.c, ppr.c, rr.u, ppr.u, N = NA, n,
  rg, se)
}
\arguments{
\item{C}{Population size (number of clusters), NA = unknown (default)}

\item{pstar.c}{cluster level design prevalence (scalar)}

\item{pstar.u}{unit level design prevalence (scalar)}

\item{rr.c}{cluster level relative risks (vector with length 
corresponding to the number of risk strata), 
use rr.c = c(1,1) if risk factor does not apply}

\item{ppr.c}{cluster level population proportions for risk 
categories (vector), NA if no cluster level risk factor}

\item{rr.u}{unit level relative risks (vector with length 
corresponding to the number of risk strata), 
use rr.u = c(1,1) if risk factor does not apply}

\item{ppr.u}{unit level population proportions for each risk group (optional) 
matrix, 1 row for each cluster, columns = unit level risk groups, 
not required if N is provided}

\item{N}{population size per risk group for each cluster, 
NA or matrix of N for each risk group 
for each cluster, N=NA means cluster sizes not provided}

\item{n}{sample size per risk group for each cluster sampled,
matrix, 1 row for each cluster, columns = unit level risk groups}

\item{rg}{vector of cluster level risk group (index) for each cluster}

\item{se}{unit sensitivity for each cluster, scalar or 
vector of values for each cluster, equal in length to n}
}
\value{
list of 2 elements, a scalar of population-level (surveillance system) 
  sensitivity and a vector of cluster-level sensitivities
}
\description{
Calculates system sensitivity for 2 stage risk-based 
  sampling, llowing for a single risk factor at each stage and
  using either binomial or hypergeometric approxiation
}
\examples{
# examples for sse.rb.2stage
pstar.c<- 0.02
pstar.u<- 0.1
rr.c<- c(5, 1)
ppr.c<- c(0.1, 0.9)
rr.u<- c(3, 1)
se<- 0.9
n<- cbind(rep(10, 50), rep(5, 50))    
rg<- c(rep(1, 30), rep(2, 20))
ppr.u<- cbind(rep(0.2, 50), rep(0.8, 50))
N<- cbind(rep(30, 50), rep(120, 50))
C<- 500        
sse.rb.2stage(C=NA, pstar.c, pstar.u, rr.c, ppr.c, rr.u, ppr.u, N=NA, n, rg, se) 
sse.rb.2stage(C, pstar.c, pstar.u, rr.c, ppr.c, rr.u, ppr.u, N=NA, n, rg, se) 
sse.rb.2stage(C=NA, pstar.c, pstar.u, rr.c, ppr.c, rr.u, ppr.u, N, n, rg, se) 
sse.rb.2stage(C, pstar.c, pstar.u, rr.c, ppr.c, rr.u, ppr.u, N, n, rg, se) 
}
\keyword{methods}

