% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freedom_functions_2.R
\name{sph.binom}
\alias{sph.binom}
\title{Binomial population specificity for imperfect test}
\usage{
sph.binom(n, c = 1, sp)
}
\arguments{
\item{n}{sample size (scalar or vector)}

\item{c}{The cut-point number of positives to classify a cluster
as positive, default=1, if positives < c result is negative, 
>= c is positive (scalar or vector of same length as n)}

\item{sp}{test unit specificity (scalar or vector of same length as n)}
}
\value{
a vector of population-level specificities
}
\description{
Calculates population specificity for a large or unknown population, 
  using the Binomial distribution and adjusting for cut-point number of positives
}
\examples{
# examples for sph.imperfect.sp
sph.binom(30, 2, 0.98)
sph.binom(30, 1, 0.98)
sph.binom(1:5*10, 2, 0.98)
sph.binom(100, 1:5, 0.98)
sph.binom(100, 3, 95:100/100)
sph.binom(c(5, 10, 15, 20, 30, 50, 100, 200), 2, 0.98)
}
\keyword{methods}

