% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/risk_based_functions.R
\name{n.rb.varse}
\alias{n.rb.varse}
\title{Risk-based sample size for varying unit sensitivity}
\usage{
n.rb.varse(pstar, rr, ppr, spr, se, spr.rg, sep)
}
\arguments{
\item{pstar}{design prevalence (scalar)}

\item{rr}{relative risk values (vector, length equal to the number of risk strata)}

\item{ppr}{population proportions for each risk group,
vector of same length as rr}

\item{spr}{planned surveillance proportions for each risk group,
vector of same length as rr}

\item{se}{unit sensitivities (vector of group values)}

\item{spr.rg}{proportions of samples for each sensitivity value 
in each risk group (matrix with rows = risk groups, columns = sensitivity values),
row sums must equal 1}

\item{sep}{required population sensitivity (scalar)}
}
\value{
list of 3 elements, a matrix of sample sizes for each risk 
  and sensitivity group, a vector of EPI values and a vector of 
  mean sensitivity for each risk group
}
\description{
Calculates sample size for risk-based sampling 
  for a single risk factor and varying unit sensitivity, 
  using binomial method
}
\examples{
# examples for n.rb.varse
m<- rbind(c(0.8, 0.2), c(0.5, 0.5), c(0.7, 0.3))
n.rb.varse(0.01, c(5, 3, 1), c(0.1, 0.1, 0.8), c(0.4, 0.4, 0.2), c(0.92, 0.8), m, 0.95)

m<- rbind(c(0.8, 0.2), c(0.6, 0.4))
n.rb.varse(0.05, c(3, 1), c(0.2, 0.8), c(0.7, 0.3), c(0.95, 0.8), m, 0.95)

m<- rbind(c(1), c(1))
n.rb.varse(0.05, c(3, 1), c(0.2, 0.8), c(0.7, 0.3), c(0.95), m, 0.99)
}
\keyword{methods}

