% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_api_repo.R
\name{repo_upload_ext_packages}
\alias{repo_upload_ext_packages}
\title{Uploads external packages into the managed repository.}
\usage{
repo_upload_ext_packages(repo_manager, pkgs, prj = NULL,
  pkg_type = .Platform$pkgType, with_deps = FALSE)
}
\arguments{
\item{repo_manager}{repo manager to use for uploading. (type: rsuite_repo_manager)}

\item{pkgs}{vector of names of external packages which should be included in
PKGZIP. (type: character)}

\item{prj}{project object to use. If not passed will init project from
working directory. (type: rsuite_project, default: NULL)}

\item{pkg_type}{type of packages to upload (type: character, default: platform default)}

\item{with_deps}{If TRUE will include pkgs dependencies while uploading into the
repository. Packages in repository satisfying pkgs requirements will not be
included. (type: logical, default: FALSE)}
}
\description{
It uses the project to detect repositories to look for external packages in.
}
\details{
Logs all messages onto rsuite logger. Use \code{logging::setLevel} to
control logs verbosity.
}
\examples{
\donttest{
  # create exemplary project base folder
  prj_base <- tempfile("example_")
  dir.create(prj_base, recursive = TRUE, showWarnings = FALSE)

  # start project
  prj <- prj_start("my_project", skip_rc = TRUE, path = prj_base)

  # set it to use in project repository and CRAN
  prj_config_set_repo_adapters(c("Dir", "CRAN"), prj = prj)

  # start managing in project repository
  rmgr <- repo_mng_start("Dir", prj = prj, ix = 1)

  # upload logging package from CRAN into the repository
  repo_upload_ext_packages(rmgr, "logging", prj = prj, pkg_type = "source")

  # list available packages
  repo_mng_list(rmgr, pkg_type = "source")

  # stop repository management
  repo_mng_stop(rmgr)
}

}
\seealso{
Other in repository management: \code{\link{repo_mng_init}},
  \code{\link{repo_mng_list}},
  \code{\link{repo_mng_remove}},
  \code{\link{repo_mng_start}},
  \code{\link{repo_mng_stop}},
  \code{\link{repo_upload_bioc_package}},
  \code{\link{repo_upload_github_package}},
  \code{\link{repo_upload_package_files}},
  \code{\link{repo_upload_pkgzip}},
  \code{\link{repo_upload_prj_packages}}
}
\concept{in repository management}
