% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_api_prj.R
\name{prj_build}
\alias{prj_build}
\title{Builds project internal packages and installs them.}
\usage{
prj_build(prj = NULL, type = NULL, rebuild = FALSE,
  vignettes = TRUE, tag = FALSE)
}
\arguments{
\item{prj}{project to build if not passed will build project for working
directory. (type: rsuite_project, default: NULL)}

\item{type}{type of packages to build. If NULL will build platform default.
(type: character)}

\item{rebuild}{if TRUE will force rebuild all project packages event if no
changes detected (type: logical)}

\item{vignettes}{if FALSE will not build vignettes which can highly decrease
package building time (type: logical, default: TRUE)}

\item{tag}{if TRUE will tag packages with RC revision. Enforces rebuild.
(type: logical; default: FALSE)}
}
\description{
Builds project internal packages and installs them.
}
\details{
Logs all messages from the building process onto the rsuite logger. Use
\code{logging::setLevel} to control logs verbosity. DEBUG level turns
on building and downloading messages.
}
\examples{
\donttest{
  # create exemplary project base folder
  prj_base <- tempfile("example_")
  dir.create(prj_base, recursive = TRUE, showWarnings = FALSE)

  # start project
  prj <- prj_start("my_project", skip_rc = TRUE, path = prj_base)

  # create package in the project
  prj_start_package("mypackage", prj = prj, skip_rc = TRUE)

  # build project local environment
  prj_install_deps(prj = prj)

  # build mypackage and install it into project environment
  prj_build(prj = prj)
}

}
\seealso{
Other in project management: \code{\link{prj_clean_deps}},
  \code{\link{prj_init}}, \code{\link{prj_install_deps}},
  \code{\link{prj_load}}, \code{\link{prj_lock_env}},
  \code{\link{prj_pack}}, \code{\link{prj_start_package}},
  \code{\link{prj_start}}, \code{\link{prj_unload}},
  \code{\link{prj_zip}}
}
\concept{in project management}
