% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggRGB.R
\name{ggRGB}
\alias{ggRGB}
\title{Create ggplot2 Raster Plots with RGB from 3 RasterLayers}
\usage{
ggRGB(img, r = 3, g = 2, b = 1, scale, maxpixels = 5e+05,
  stretch = "none", ext = NULL, limits = NULL, clipValues = "limits",
  quantiles = c(0.02, 0.98), ggObj = TRUE, ggLayer = FALSE, alpha = 1,
  coord_equal = TRUE, geom_raster = FALSE, nullValue = 0)
}
\arguments{
\item{img}{RasterStack or RasterBrick}

\item{r}{Integer or character. Red layer in x. Can be set to \code{NULL}, in which case the red channel will be set to zero.}

\item{g}{Integer or character. Green layer in x. Can be set to \code{NULL}, in which case the green channel will be set to zero.}

\item{b}{Integer or character. Blue layer in x. Can be set to \code{NULL}, in which case the blue channel will be set to zero.}

\item{scale}{Numeric. Maximum possible pixel value (optional). Defaults to 255 or to the maximum value of x if that is larger than 255}

\item{maxpixels}{Integer. Maximal number of pixels used for plotting.}

\item{stretch}{Character. Either 'none', 'lin', 'hist', 'sqrt' or 'log' for no stretch, linear, histogram, square-root or logarithmic stretch.}

\item{ext}{Extent object to crop the image}

\item{limits}{Vector or matrix. Can be used to reduce the range of values. Either a vector of two values for all bands (c(min, max))
or a 3x2 matrix with min and max values (columns) for each layer (rows).}

\item{clipValues}{Matrix, numeric vector, string or NA. Values to reset out of range (out of \code{limits}) values to. 
By default ('limits') values are reset to \code{limits}. A single value (e.g. NA) will be recycled to all lower/higher clippings,
A vector of length two (c(min,max)) can be used to specify lower and higher replace values, applied to all bands. 
A two column matrix (typically with three rows) can be used to fully control lower and upper clipping values differently for each band.}

\item{quantiles}{Numeric vector with two elements. Min and max quantiles to stretch. Defaults to 2\% stretch, i.e. c(0.02,0.98).}

\item{ggObj}{Logical. If \code{TRUE} a ggplot2 object is returned. If \code{FALSE} a data.frame with coordinates and color will be returned.}

\item{ggLayer}{Logical. If \code{TRUE} a ggplot2 layer is returned. This is usefull if you want to add it to an existing ggplot2 object.
Note that if \code{TRUE} & \code{annotate = FALSE} you have to add a scale_fill_identity() manually in your call to ggplot().}

\item{alpha}{Numeric. Transparency (0-1).}

\item{coord_equal}{Logical. Force addition of coord_equal, i.e. aspect ratio of 1:1. Typically usefull for remote sensing data (depending on your projection), hence it defaults to TRUE.
Note howver, that this does not apply if (\code{ggLayer=FALSE}).}

\item{geom_raster}{Logical. If \code{FALSE} annotation_raster is used, otherwise geom_raster()+scale_fill_identity is used.
Note that you can't use scale_fill* in addition to the latter, because it already requires scale_fill_identity().}

\item{nullValue}{Numeric. Intensity value used for NULL layers in color compositing. E.g. set g=NULL and fix green value at 0.5 (defaults to 0).}
}
\value{
\tabular{ll}{
 \code{ggObj = TRUE}:   \tab ggplot2 plot \cr
 \code{ggLayer = TRUE}: \tab ggplot2 layer to be combined with an existing ggplot2 \cr
 \code{ggObj = FALSE}:  \tab data.frame in long format suitable for plotting with ggplot2, includes the pixel values and the calculated colors \cr  
}
}
\description{
Calculates RGB color composite raster for plotting with ggplot2. Optional values for clipping and and stretching can be used to enhance the imagery.
}
\details{
Functionality is based on \code{\link[raster]{plotRGB}} from the raster package.
}
\examples{
  
library(ggplot2)
data(rlogo)

ggRGB(rlogo, r=1, g=2, b=3)

## Define minMax ranges
ggRGB(rlogo, r=1,g=2, b=3, limits = matrix(c(100,150,10,200,50,255),  ncol = 2, by = TRUE))

## Perform stong linear contrast stretch
ggRGB(rlogo, r = 1, g = 2, b = 3,stretch = "lin", quantiles = c(0.2, 0.8))

## Use only two layers for color calculation
ggRGB(rlogo, r = 1, g = 2, b = NULL)

## Return only data.frame
df <- ggRGB(rlogo, ggObj = FALSE)
head(df)

## Use in layer-mode, e.g. to add to another plot
wave <- data.frame(x = c(0, 0:100,100), y = c(0,sin(seq(0,2*pi,pi/50))*10+20, 0))
p <- ggplot(wave, aes(x, y)) 
p + ggRGB(rlogo, ggLayer = TRUE) + 
       geom_polygon(aes(x, y), fill = "blue", alpha = 0.4) +
       coord_equal(ylim=c(0,75))
}
\seealso{
\link{ggR}, \link[=fortify.raster]{fortify}
}

