% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QueueSummary.R
\name{QueueSummary}
\alias{QueueSummary}
\title{Run a Summary Report}
\usage{
QueueSummary(reportsuite.ids, date, metrics, interval.seconds = 5,
  max.attempts = 120, validate = TRUE, date.from = "", date.to = "",
  enqueueOnly = FALSE)
}
\arguments{
\item{reportsuite.ids}{Report suite ids}

\item{date}{Time period for the report (see Description)}

\item{metrics}{List of metrics to include in the report}

\item{interval.seconds}{How long to wait between attempts}

\item{max.attempts}{Number of API attempts before stopping}

\item{validate}{Whether to submit report definition for validation before requesting the data.}

\item{date.from}{Start date for the report (YYYY-MM-DD)}

\item{date.to}{End date for the report (YYYY-MM-DD)}

\item{enqueueOnly}{only enqueue the report, don't get the data. returns report id, which you can later use to get the data}
}
\value{
Data frame
}
\description{
A QueueSummary report is a summary report of metrics for one or more report
suites for a given time period. Time period in the date parameter can be specified as year only ("2015"),
year-month ("2015-04") or year-month-day ("2015-04-20"); alternatively, date.to and date.from
are available for custom date ranges.
}
\details{
The QueueSummary function returns a data frame containing a metric summary for the time period
selected.

Because of the Reporting API structure, this function first requests the
report, then checks the reporting queue to see if the report is completed, and
when the report returns as "done" pulls the report from the API. This checking
process will occur up to the specified number of times (default 120), with a
delay between status checks (default 5 seconds). If the report does not return
as "done" after the number of tries have completed, the function will return an
error message.
}
\examples{
\dontrun{

aa <- QueueSummary("zwitchdev", "2015", c("pageviews", "visits"))
bb <- QueueSummary("zwitchdev", "", c("pageviews", "visits"), 
                   date.from = "2016-01-01", date.to="2016-01-15")
enqueued.reprot.id <- QueueSummary("zwitchdev", "", c("pageviews", "visits"), 
                   date.from = "2016-01-01", date.to="2016-01-15",
                   enqueueOnly=TRUE)
}

}

