% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scelestial.R
\name{distance.matrix.tree}
\alias{distance.matrix.tree}
\title{Calculates distance matrix for a nodes on a tree.}
\usage{
distance.matrix.tree(graph, cell.names, tree.nodes, normalize = TRUE)
}
\arguments{
\item{graph}{The tree}

\item{cell.names}{Name of the cells to be the row and column
name of the resulting matrix}

\item{tree.nodes}{For each cell.names a tree node is stored
in tree.nodes.}

\item{normalize}{If TRUE the resulting matrix is normalized.}
}
\value{
A matrix with equal number of rows and columns, a row/column
  for each cell. Elements of matrix represent distance between cells
  on the \code{graph}.
}
\description{
It is used for internal purposes.
}
\examples{
## Synthesise an evolution
S = synthesis(10, 5, 20, seed=7)
## Run Scelestial
SC = scelestial(as.ten.state.matrix(S$seqeunce))
## Calculate the distance matrix
vertices <- rownames(SC$input);
distance.matrix.tree(SC$tree, vertices, vertices, normalize = TRUE)
#              C1         C10          C2          C3          C4
# C1  0.000000000 0.003512891 0.015222451 0.014051472 0.008196692
# C10 0.003512891 0.000000000 0.011709560 0.010538580 0.004683800
# C2  0.015222451 0.011709560 0.000000000 0.010538627 0.007025759
# C3  0.014051472 0.010538580 0.010538627 0.000000000 0.005854780
# C4  0.008196692 0.004683800 0.007025759 0.005854780 0.000000000
# C5  0.011709560 0.008196668 0.003512891 0.007025736 0.003512868
# C6  0.023419213 0.019906322 0.019906368 0.009367741 0.015222521
# C7  0.018735342 0.015222451 0.015222498 0.004683871 0.010538651
# C8  0.015222474 0.011709583 0.014051542 0.012880562 0.007025783
# C9  0.010538627 0.007025736 0.009367695 0.008196715 0.002341935
# C5          C6          C7          C8          C9
# C1  0.011709560 0.023419213 0.018735342 0.015222474 0.010538627
# C10 0.008196668 0.019906322 0.015222451 0.011709583 0.007025736
# C2  0.003512891 0.019906368 0.015222498 0.014051542 0.009367695
# C3  0.007025736 0.009367741 0.004683871 0.012880562 0.008196715
# C4  0.003512868 0.015222521 0.010538651 0.007025783 0.002341935
# C5  0.000000000 0.016393477 0.011709606 0.010538651 0.005854803
# C6  0.016393477 0.000000000 0.004683871 0.022248304 0.017564457
# C7  0.011709606 0.004683871 0.000000000 0.017564433 0.012880586
# C8  0.010538651 0.022248304 0.017564433 0.000000000 0.004683847
# C9  0.005854803 0.017564457 0.012880586 0.004683847 0.000000000

}
