% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jsUnitTestMethods.R
\name{startJsUnitTests}
\alias{startJsUnitTests}
\title{Start JS Unit Tests}
\usage{
startJsUnitTests(account, username = Sys.getenv("SLUSER"), platforms, url,
  framework, ...)
}
\arguments{
\item{account}{An object of class "account". An account object see \code{\link{account}}.}

\item{username}{SauceLabs username}

\item{platforms}{A list of platforms (see example)}

\item{url}{should point to the page that hosts your tests}

\item{framework}{can be "qunit", "jasmine", "YUI Test", "mocha", or "custom"}

\item{...}{Additonal function arguments - Currently unused.}
}
\description{
Start your JavaScript unit tests on as many browsers as you like with a single request
}
\examples{
\dontrun{
# use test example from
#https://wiki.saucelabs.com/display/DOCS/JavaScript+Unit+Testing+Methods
platforms <- list(c("Windows 7", "firefox", "27"),
                    c("Linux", "googlechrome", "")
                    )
appUrl <- "https://saucelabs.com/test_helpers/front_tests/index.html"
framework <- "jasmine"
myAcc <- account()
myTest <- startJsUnitTests(myAcc, platforms = platforms, url = appUrl, framework = framework)

#> unlist(myTest, use.names = FALSE)
#[1] "bc8b9ef6e6184ed8a7e5270344115999" "bf43cef30bca429eaa2ed08da09dbdce"
testIds <- unlist(myTest, use.names = FALSE)
testRes <- getJsUnitTestStatus(myAcc,js_tests = testIds)

}
}
\seealso{
Other jsUnitTestMethods: \code{\link{getJsUnitTestStatus}}
}

