% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meteofranceSynop.R
\docType{data}
\name{meteofranceSynop}
\alias{meteofranceSynop}
\title{SYNOP Weather Data in France}
\format{data.frame}
\source{
\url{https://donneespubliques.meteofrance.fr}(in pariticular \url{https://donneespubliques.meteofrance.fr/?fond=produit&id_produit=94&id_rubrique=32})
}
\usage{
data(meteofranceSynop)
}
\description{
\code{data.frame} table containing SYNOP weather data obtained through \code{MeteoDataFrance} R package (\url{https://github.com/ecor/MeteoDataFrance})
}
\examples{
 

library(ggmap)
data(meteofranceSynop)


\dontrun{
## See help(get_map) documentation and run the example with a connection to Google!
data=meteofranceSynop[meteofranceSynop$timestamp==meteofranceSynop$timestamp[250],]



map <- get_map(location ="France", zoom = 6)

size <- 3

gsynop <- ggmap(map) +
		geom_point(data = data,aes(x = longitude, y = latitude),size=size,  alpha
						=1, color="blue",show.legend  = FALSE)

## Uncomment if you want to save in PDF format the otput of gsynop
## ggsave("test-map.pdf", gsynop,width=10,height=10)
} 
}
\author{
Emanuele Cordano
}

