% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist.interval.R
\name{sym.dist.interval}
\alias{sym.dist.interval}
\title{Distance for Symbolic Interval Variables.}
\usage{
sym.dist.interval(sym.data, gamma = 0.5, method = "Minkowski",
  normalize = TRUE, SpanNormalize = FALSE, q = 1, euclidea = TRUE,
  pond = rep(1, length(variables)))
}
\arguments{
\item{sym.data}{A symbolic object}

\item{gamma}{gamma value for the methods ichino and minkowski.}

\item{method}{Method to use (Gowda.Diday, Ichino, Minkowski, Hausdorff)}

\item{normalize}{A logical value indicating whether normalize the data in the ichino or hausdorff method.}

\item{SpanNormalize}{A logical value indicating whether}

\item{q}{q value for the hausdorff method.}

\item{euclidea}{A logical value indicating whether use the euclidean distance.}

\item{pond}{A numeric vector}

\item{variables}{Numeric vector with the number of the variables to use.}
}
\value{
An object of class 'dist'
}
\description{
This function computes and returns the distance matrix by using the specified
distance measure to compute distance between symbolic interval variables.
}
\examples{

data('table7')
ex3 <- classic.to.sym(table7, concept=c('Animal'),variables = c(Height, Weight)
,variables.types=c(Height = type.interval(), Weight = type.interval()))
sym.dist.interval(ex3,method='Gowda.Diday',normalize=FALSE)
sym.dist.interval(ex3,gamma=0.5,method='Ichino',normalize=FALSE)
sym.dist.interval(ex3,gamma=0.5,method='Minkowski',normalize=FALSE,q=1)
sym.dist.interval(ex3,gamma=0.5,method='Minkowski',normalize=FALSE,q=2)
sym.dist.interval(ex3,gamma=0.5,method='Hausdorff',normalize=FALSE,
SpanNormalize=FALSE,euclidea=TRUE)
sym.dist.interval(ex3,gamma=0.5,method='Hausdorff',normalize=FALSE,
SpanNormalize=TRUE,euclidea=TRUE)
}
