/*
 * Decompiled with CFR 0.152.
 */
package org.act.util;

import java.util.Arrays;
import org.act.util.ProbDistribution;
import org.apache.commons.math3.distribution.NormalDistribution;

public class UniDimNormalDistribution
implements ProbDistribution {
    private double mean;
    private double sd;
    private NormalDistribution normDist;

    public UniDimNormalDistribution(double mean, double sd) {
        this.mean = mean;
        this.sd = sd;
        this.normDist = new NormalDistribution(mean, sd);
    }

    @Override
    public int getDim() {
        return 1;
    }

    @Override
    public ProbDistribution.TYPE getType() {
        return ProbDistribution.TYPE.NORMAL;
    }

    @Override
    public double density(double ... x) {
        return this.normDist.density(x[0]);
    }

    @Override
    public double[] sample(int n, double min, double max) {
        double[] samples = new double[n];
        if (min > max) {
            throw new IllegalArgumentException("Min should not be greater than Max.");
        }
        if (min == max) {
            Arrays.fill(samples, min);
            return samples;
        }
        for (int i = 0; i < n; ++i) {
            double value = this.normDist.sample();
            while (value > max || value < min) {
                value = this.normDist.sample();
            }
            samples[i] = value;
        }
        return samples;
    }

    @Override
    public double[] sample(int n) {
        return this.normDist.sample(n);
    }

    @Override
    public double mean() {
        return this.mean;
    }

    @Override
    public double sd() {
        return this.sd;
    }
}

