/*
 * Decompiled with CFR 0.152.
 */
package org.act.cat;

import org.act.cat.CatFunctions;
import org.act.cat.ItemSelectionMethod;
import org.apache.commons.math3.linear.RealMatrix;

public class EBIMethod
implements ItemSelectionMethod {
    private RealMatrix itemPar;
    private double thetaEst;
    private double thetaSe;

    public EBIMethod(RealMatrix itemPar, double thetaEst, double thetaSe) {
        this.itemPar = itemPar;
        this.thetaEst = thetaEst;
        this.thetaSe = thetaSe;
    }

    @Override
    public double[] getSelectionCriteria() {
        int parNum = this.itemPar.getRowDimension();
        double[] ebiValues = new double[parNum];
        for (int i = 0; i < parNum; ++i) {
            double a = this.itemPar.getEntry(i, 0);
            double b = this.itemPar.getEntry(i, 1);
            double c = this.itemPar.getEntry(i, 2);
            double d = this.itemPar.getEntry(i, 3);
            double maxInfo = this.calMaxInfo(a, b, c, d);
            ebiValues[i] = this.calEBI(maxInfo, a, b, c, d);
        }
        return ebiValues;
    }

    @Override
    public ItemSelectionMethod.SUPPORTED_METHODS getMethodType() {
        return ItemSelectionMethod.SUPPORTED_METHODS.MAX_FISHER_INFO;
    }

    private double calMaxInfo(double a, double b, double c, double d) {
        double thetaMax = b + 1.0 / (a * d) * Math.log((1.0 + Math.pow(1.0 + 8.0 * c, 0.5)) / 2.0);
        return CatFunctions.calInfo(thetaMax, a, b, c, d);
    }

    private double calEBI(double maxInfo, double a, double b, double c, double d) {
        int stepNum = 100;
        double interval = 4.0 * this.thetaSe / (double)stepNum;
        double ebi = 0.0;
        double theta = this.thetaEst - 2.0 * this.thetaSe;
        for (int i = 0; i < stepNum; ++i) {
            ebi += CatFunctions.calInfo(theta + ((double)i + 0.5) * interval, a, b, c, d) * interval;
        }
        return ebi * (1.0 + 1.0 / maxInfo);
    }
}

