% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RSAGA-modules.R
\name{rsaga.esri.to.sgrd}
\alias{rsaga.esri.to.sgrd}
\title{Convert ESRI ASCII/binary grids to SAGA grids}
\usage{
rsaga.esri.to.sgrd(in.grids, out.sgrds = set.file.extension(in.grids,
  ".sgrd"), in.path, ...)
}
\arguments{
\item{in.grids}{character vector of ESRI ASCII/binary grid files (default file extension: \code{.asc}); files should be located in folder \code{in.path}}

\item{out.sgrds}{character vector of output SAGA grid files; defaults to \code{in.grids} with file extension being replaced by \code{.sgrd}, which is also the default extension if file names without extension are specified; files will be placed in the current SAGA workspace (default: \code{\link{rsaga.env}()$workspace}, or \code{env$workspace} if an \code{env} argument is provided}

\item{in.path}{folder with \code{in.grids}}

\item{...}{optional arguments to be passed to \code{\link[=rsaga.geoprocessor]{rsaga.geoprocessor()}}, including the \code{env} RSAGA geoprocessing environment}
}
\value{
The type of object returned depends on the \code{intern} argument passed to the \code{\link[=rsaga.geoprocessor]{rsaga.geoprocessor()}}. For \code{intern=FALSE} it is a numerical error code (0: success), or otherwise (default) a character vector with the module's console output.

If multiple \code{in.grids} are converted, the result will be a vector of numerical error codes of the same length, or the combination of the console outputs with \code{c()}.
}
\description{
\code{rsaga.esri.to.sgrd} converts grid files from ESRI's ASCII (.asc) and binary (.flt) format to SAGA's (version 2) grid format (.sgrd).
}
\note{
This function uses module 1 from the SAGA library \code{io_grid}.
}
\seealso{
\code{\link[=rsaga.esri.wrapper]{rsaga.esri.wrapper()}} for an efficient way of applying RSAGA to ESRI ASCII/binary grids; \code{\link[=rsaga.env]{rsaga.env()}}
}
\author{
Alexander Brenning (R interface), Olaf Conrad (SAGA module)
}
\keyword{file}
\keyword{interface}
\keyword{spatial}
