% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/RSAGA-modules.R
\name{rsaga.sgrd.to.esri}
\alias{rsaga.sgrd.to.esri}
\title{Convert SAGA grids to ESRI ASCII/binary grids}
\usage{
rsaga.sgrd.to.esri(in.sgrds, out.grids, out.path, format = "ascii",
  georef = "corner", prec = 5, ...)
}
\arguments{
\item{in.sgrds}{character vector of SAGA grid files (\code{.sgrd}) to be converted;  files are expected to be found in folder \code{\link{rsaga.env}()$workspace}, or, if an optional \code{env} argument is provided, in \code{env$workspace}}

\item{out.grids}{character vector of ESRI ASCII/float output file names; defaults to \code{in.sgrds} with the file extension being replaced by \code{.asc} or \code{.flt}, depending on \code{format}. Files will be placed in folder \code{out.path}, existing files will be overwritten}

\item{out.path}{folder for \code{out.grids}}

\item{format}{output file format, either \code{"ascii"} (default; equivalent: \code{format=1}) for ASCII grids or \code{"binary"} (equivalent: \code{0}) for binary ESRI grids (\code{.flt}).}

\item{georef}{character: \code{"corner"} (equivalent numeric code: \code{0}) or \code{"center"} (default; equivalent: \code{1}). Determines whether the georeference will be related to the center or corner of its extreme lower left grid cell.}

\item{prec}{number of digits when writing floating point values to ASCII grid files; either a single number (to be replicated if necessary), or a numeric vector of length \code{length(in.grids)}}

\item{...}{optional arguments to be passed to \code{\link{rsaga.geoprocessor}}, including the \code{env} RSAGA geoprocessing environment}
}
\value{
The type of object returned depends on the \code{intern} argument passed to the \code{\link{rsaga.geoprocessor}}. For \code{intern=FALSE} it is a numerical error code (0: success), or otherwise (default) a character vector with the module's console output.
}
\description{
\code{rsaga.sgrd.to.esri} converts grid files from SAGA's (version 2) grid format (.sgrd) to ESRI's ASCII (.asc)  and binary (.flt) format.
}
\note{
This function uses module 0 from the SAGA library \code{io_grid}.
}
\author{
Alexander Brenning (R interface), Olaf Conrad (SAGA module)
}
\seealso{
\code{\link{rsaga.esri.wrapper}} for an efficient way of applying RSAGA to ESRI ASCII/binary grids; \code{\link{rsaga.env}}
}
\keyword{file}
\keyword{interface}
\keyword{spatial}

