% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist.mrv_histogram.R
\name{mrv_histogram}
\alias{mrv_histogram}
\title{mrv_histogram}
\description{
Multivariate rv_histogram distribution in OOP way.
}
\details{
Used for a multivariate dataset, fit each marge
}
\examples{
## Generate sample
X = matrix( stats::rnorm( n = 10000 ) , ncol = 4 )

## And fit it
rvX = mrv_histogram$new()
rvX$fit(X)

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{n_features}}{[integer] Number of features (dimensions)}

\item{\code{law_}}{[list] List of marginal distributions}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-mrv_histogram-new}{\code{mrv_histogram$new()}}
\item \href{#method-mrv_histogram-fit}{\code{mrv_histogram$fit()}}
\item \href{#method-mrv_histogram-rvs}{\code{mrv_histogram$rvs()}}
\item \href{#method-mrv_histogram-cdf}{\code{mrv_histogram$cdf()}}
\item \href{#method-mrv_histogram-sf}{\code{mrv_histogram$sf()}}
\item \href{#method-mrv_histogram-icdf}{\code{mrv_histogram$icdf()}}
\item \href{#method-mrv_histogram-isf}{\code{mrv_histogram$isf()}}
\item \href{#method-mrv_histogram-clone}{\code{mrv_histogram$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mrv_histogram-new"></a>}}
\if{latex}{\out{\hypertarget{method-mrv_histogram-new}{}}}
\subsection{Method \code{new()}}{
Create a new mrv_histogram object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mrv_histogram$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{If a param `Y` is given, the fit method is called with `...`.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `mrv_histogram` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mrv_histogram-fit"></a>}}
\if{latex}{\out{\hypertarget{method-mrv_histogram-fit}{}}}
\subsection{Method \code{fit()}}{
Fit method for the histograms
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mrv_histogram$fit(Y, bins = as.integer(100))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Y}}{[vector] Dataset to infer the histogram}

\item{\code{bins}}{[list or vector or integer] bins values}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
`self`
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mrv_histogram-rvs"></a>}}
\if{latex}{\out{\hypertarget{method-mrv_histogram-rvs}{}}}
\subsection{Method \code{rvs()}}{
Generation sample from the histogram
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mrv_histogram$rvs(n = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{[integer] Number of samples drawn}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A matrix of samples
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mrv_histogram-cdf"></a>}}
\if{latex}{\out{\hypertarget{method-mrv_histogram-cdf}{}}}
\subsection{Method \code{cdf()}}{
Cumulative Distribution Function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mrv_histogram$cdf(q)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{q}}{[vector] Quantiles to compute the CDF}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
cdf values
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mrv_histogram-sf"></a>}}
\if{latex}{\out{\hypertarget{method-mrv_histogram-sf}{}}}
\subsection{Method \code{sf()}}{
Survival Function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mrv_histogram$sf(q)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{q}}{[vector] Quantiles to compute the SF}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
sf values
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mrv_histogram-icdf"></a>}}
\if{latex}{\out{\hypertarget{method-mrv_histogram-icdf}{}}}
\subsection{Method \code{icdf()}}{
Inverse of Cumulative Distribution Function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mrv_histogram$icdf(p)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{p}}{[vector] Probabilities to compute the CDF}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
icdf values
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mrv_histogram-isf"></a>}}
\if{latex}{\out{\hypertarget{method-mrv_histogram-isf}{}}}
\subsection{Method \code{isf()}}{
Inverse of Survival Function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mrv_histogram$isf(p)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{p}}{[vector] Probabilities to compute the SF}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
isf values
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mrv_histogram-clone"></a>}}
\if{latex}{\out{\hypertarget{method-mrv_histogram-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mrv_histogram$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
