% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sqlExecute.R
\name{sqlExecute}
\alias{sqlExecute}
\title{Executes an already prepared query}
\usage{
sqlExecute(channel, query = NULL, data = NULL, fetch = FALSE,
  errors = TRUE, rows_at_time = attr(channel, "rows_at_time"),
  force_loop = FALSE, ...)
}
\arguments{
\item{channel}{ODBC connection obtained by \link[RODBC]{odbcConnect}}

\item{query}{a query string (NULL if query already prepared using
\link{sqlPrepare})}

\item{data}{data to pass to sqlExecute (as data.frame)}

\item{fetch}{whether to automatically fetch results (if data provided)}

\item{errors}{whether to display errors}

\item{rows_at_time}{number of rows to fetch at one time - see details of
\link[RODBC]{sqlQuery}}

\item{force_loop}{whether to execute queries in the explicit loop with
separate query planing for each iteration (usefull if executing a query
invalidates its plan, e.g. EXEC queries on Ms SQL Server)}

\item{...}{parameters to pass to \link[RODBC]{sqlGetResults} (if fetch=TRUE)}
}
\value{
see datails
}
\description{
Executes a parameterized query.

Optionally (fetch=TRUE) fetches results using \link[RODBC]{sqlGetResults}.

Optionally (query=NULL) uses query already prepared by \link{sqlPrepare}.
}
\details{
Return value depends on the combination of parameters:
\itemize{
  \item if there were errors during query preparation or execution or fetching results
    return value depends on errors parameter - if errors=TRUE error is thrown,
    otherwise -1 will be returned
  \item if fetch=FALSE and there were no errors invisible(1) will be returned
  \item if fetch=TRUE and there were no errors a data.frame with results will be returned
}
}
\examples{
\dontrun{
  conn = odbcConnect('MyDataSource')

  # prepare, execute and fetch results separatly
  sqlPrepare(conn, "SELECT * FROM myTable WHERE column = ?")
  sqlExecute(conn, NULL, 'myValue')
  sqlGetResults(conn)

  # prepare and execute at one time, fetch results separately
  sqlExecute(conn, "SELECT * FROM myTable WHERE column = ?", 'myValue')
  sqlGetResults(conn)

  # prepare, execute and fetch at one time
  sqlExecute(conn, "SELECT * FROM myTable WHERE column = ?", 'myValue', TRUE)

  # prepare, execute and fetch at one time, pass additional parameters to sqlFetch()
  sqlExecute(
    conn,
    "SELECT * FROM myTable WHERE column = ?",
    'myValue',
    TRUE,
    stringsAsFactors=FALSE
  )
}
}

