% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/newsflow.r
\name{newsflow_compare}
\alias{newsflow_compare}
\title{Create a network of document similarities over time}
\usage{
newsflow_compare(
  dtm,
  dtm_y = NULL,
  date_var = "date",
  hour_window = c(-24, 24),
  group_var = NULL,
  measure = c("cosine", "overlap_pct", "overlap", "dot_product", "softcosine"),
  tf_idf = F,
  min_similarity = 0,
  n_topsim = NULL,
  only_complete_window = T,
  ...
)
}
\arguments{
\item{dtm}{A quanteda \link[quanteda]{dfm}. Note that it is common to first weight the dtm(s) before calculating document similarity,
For this you can use quanteda's \link[quanteda]{dfm_tfidf} and \link[quanteda]{dfm_weight}}

\item{dtm_y}{Optionally, another dtm. If given, the documents in dtm will be compared to the documents in dtm_y.}

\item{date_var}{The name of the column in meta that specifies the document date. default is "date". The values should be of type POSIXct, or coercable with as.POSIXct.
If given, the hour_window argument is used to only compare documents within a time window.}

\item{hour_window}{A vector of length 2, in which the first and second value determine the left and right side of the window, respectively. 
For example, c(-10, 36) will compare each document to all documents between the previous 10 and the next 36 hours.
It is possible to specify time windows down to the level of seconds by using fractions (hours / 60 / 60).}

\item{group_var}{Optionally,  The name of the column in meta that specifies a group (e.g., source, sourcetype). If given, only documents within the same group will be compared.}

\item{measure}{The measure that should be used to calculate similarity/distance/adjacency. Currently supports the symmetrical measure "cosine" (cosine similarity), the assymetrical measures "overlap_pct" (percentage of term scores in the document 
that also occur in the other document), "overlap" (like overlap_pct, but as the sum of overlap instead of the percentage) and the symmetrical soft cosine measure (experimental).
The regular dot product (dot_product) is also supported.}

\item{tf_idf}{If TRUE, weigh the dtm (and dtm_y) by term frequency - inverse document frequency. For more control over weighting,
we recommend using quanteda's \link[quanteda]{dfm_tfidf} or \link[quanteda]{dfm_weight} on dtm and dtm_y.}

\item{min_similarity}{A threshold for similarity. lower values are deleted. For all available similarity measures zero means no similarity.}

\item{n_topsim}{An alternative or additional sort of threshold for similarity. Only keep the [n_topsim] highest similarity scores for x. Can return more than [n_topsim] similarity scores in the case of duplicate similarities.}

\item{only_complete_window}{If True, only compare articles (x) of which a full window of reference articles (y) is available. Thus, for the first and last [window.size] days, there will be no results for x.}

\item{...}{Other arguments passed to \code{\link{compare_documents}}.}
}
\value{
An igraph network.
}
\description{
This is a wrapper for the \code{\link{compare_documents}} function, specialised for the case of analyzing documents over time.
The difference is that using date_var is mandatory, and the output is returned as an igraph network (using \code{\link{as_document_network}}).
}
\examples{
dtm = quanteda::dfm_tfidf(rnewsflow_dfm)
el = newsflow_compare(dtm, date_var='date', hour_window = c(0.1, 36))
}
