% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/cypher.R
\name{cypher}
\alias{cypher}
\title{Cypher Queries to Data Frames}
\usage{
cypher(graph, query, ...)
}
\arguments{
\item{graph}{A graph object.}

\item{query}{A character string.}

\item{...}{A named list. Parameters to pass to the query in the form key = value, if applicable.}
}
\value{
A data.frame.
}
\description{
Retrieve Cypher query results as a data frame.
}
\details{
If returning data, you can only query for tabular results.
That is, you can't return node or relationship entities.
See \code{\link{cypherToList}} for returning non-tabular data.
}
\examples{
\dontrun{
graph = startGraph("http://localhost:7474/db/data/")
clear(graph)

alice = createNode(graph, "Person", name = "Alice", age = 23)
bob = createNode(graph, "Person", name = "Bob", age = 22)
charles = createNode(graph, "Person", name = "Charles", age = 25)
david = createNode(graph, "Person", name = "David", age = 20)

createRel(alice, "KNOWS", bob)
createRel(alice, "KNOWS", charles)
createRel(charles, "KNOWS", david)

cypher(graph, "MATCH n RETURN n.name, n.age")

query = "MATCH n WHERE n.age < {age} RETURN n.name, n.age"
cypher(graph, query, age = 24)

query = "MATCH n WHERE n.name IN {names} RETURN n.name, n.age"
names = c("Alice", "Charles")
cypher(graph, query, names = names)

query = "MATCH n WHERE n.age > {age1} AND n.age < {age2} RETURN n.name"
cypher(graph, query, age1=22, age2=30)

params = list(age1=22, age2=30)
cypher(graph, query, params)
}
}
\seealso{
\code{\link{cypherToList}}
}

