% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_metadata.R
\name{get_meta}
\alias{get_meta}
\title{Extracts meta objects matching properties}
\usage{
get_meta(nexml, annotated = NULL, props)
}
\arguments{
\item{nexml}{a nexml object}

\item{annotated}{the nexml component object from which to obtain metadata
annotations, or a list of such objects. Defaults to the nexml object itself.}

\item{props}{a character vector of property names for which to extract
metadata annotations}
}
\value{
a named list of the matching meta objects
}
\description{
Extracts the metadata annotations for the given property or properties,
and returns the result as a list of \code{meta} objects.
}
\details{
For matching property identifiers (i.e., URIs), prefixes in the input list
as well as in the \code{annotated} object will be expanded using the namespaces
of the \code{nexml} object. Names in the returned list are mapped to the
(possibly prefixed) form in the input list. The resulting list is flat,
and hence does not retain the nesting hierarchy in the object's annotation.
}
