% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/NaviCell_RC.R
\docType{class}
\name{NaviCell-class}
\alias{NaviCell}
\alias{NaviCell-class}
\title{NaviCell reference class}
\description{
NaviCell (https://navicell.curie.fr) is a web-based environment for
browsing, commenting and analyzing very large biological molecular networks
using Google Maps and for visualizing 'omics' data on top of the network
maps.
}
\details{
NaviCell can also act as a server allowing to be remotely controlled through
a REST API. A python and a R language bindings have been developped on top
of the REST API to hide technical details and to provide users and
programmers a friendly interface. A Java binding has been initiated.

This is the R binding implementation. For more information about the
NaviCell Web Service and a tutorial on how to use it, see
https://navicell.curie.fr/pages/nav_web_service.html and
https://github.com/eb00/RNaviCell.
}
\section{Methods}{

\describe{
\item{\code{attachLastSession(...)}}{Attach NaviCell handle to the last existing NaviCell Web Service session.}

\item{\code{attachSession(session_id)}}{Attach a NaviCell server session ID.}

\item{\code{barplotEditorApply(...)}}{Apply changes for the barplot editor.}

\item{\code{barplotEditorApplyAndClose(...)}}{Apply changes and close the barplot editor.}

\item{\code{barplotEditorCancel(...)}}{Cancel changes and close the barplot editor.}

\item{\code{barplotEditorClearSamples(...)}}{Clear all samples in the barplot editor.}

\item{\code{barplotEditorClose(...)}}{Close the barplot editor.}

\item{\code{barplotEditorOpen(...)}}{Open the barplot editor.}

\item{\code{barplotEditorSelectAllGroups(...)}}{Select all groups in the barplot editor.}

\item{\code{barplotEditorSelectAllSamples(...)}}{Select all samples in the barplot editor.}

\item{\code{barplotEditorSelectDatatable(datatable_name)}}{Select a datatable in the barplot editor.}

\item{\code{barplotEditorSelectSample(col_num, sample_name)}}{Select a sample or a group in the barplot editor. col_num = column index number, sample_name = sample or group name}

\item{\code{barplotEditorSetTransparency(value)}}{Select transparency parameter in the barplot editor. value = integer between 1 and 100}

\item{\code{continuousConfigApply(datatable_name, parameter_type)}}{Apply changes to the continuous configuration editor. parameter_type = 'size' or 'shape' or 'color'. }

\item{\code{continuousConfigApplyAndClose(datatable_name, datatable_parameter)}}{Apply changes and close continuous configuration editor for a given type of parameter. datatable_parameter = 'shape' or 'color' or 'size'.}

\item{\code{continuousConfigCancelAndClose(datatable_name, datatable_parameter)}}{Cancel changes and close continuous configuration editor for a given type of parameter. datatable_parameter = 'shape' or 'color' or 'size'.}

\item{\code{continuousConfigClose(datatable_name, datatable_parameter)}}{Close continuous configuration editor for a given type of parameter. datatable_parameter = 'shape' or 'color' or 'size'.}

\item{\code{continuousConfigOpen(datatable_name, datatable_parameter)}}{Open continuous configuration editor for a given type of parameter. datatable_parameter = 'shape' or 'color' or 'size'.}

\item{\code{continuousConfigSetAbsVal(datatable_parameter, datatable_name, checked)}}{Set absolute value mode for continuous configuration editor for a given type of parameter. datatable_parameter = 'shape' or 'color' or 'size', checked = TRUE or FALSE.}

\item{\code{continuousConfigSetColorAt(datatable_name, sample_or_group, index,
  color_hex_value)}}{Set continuous configuration color value. sample_or_group = 'sample' or 'group'.}

\item{\code{continuousConfigSetGroupMethod(datatable_parameter, datatable_name,
  method_index)}}{Set the method used when multiple symbols map to the same entity. datatable_parameter = 'shape' or 'color' or 'size', method_index = integer.}

\item{\code{continuousConfigSetSampleMethod(datatable_parameter, datatable_name,
  method_index)}}{Set the method used when multiple symbols map to the same entity. datatable_parameter = 'shape' or 'color' or 'size', method_index = integer.}

\item{\code{continuousConfigSetSelectionShape(datatable_name, sample_or_group, index, shape)}}{Set the shape selection to a given value for the 'shape' parameter. sample_or_group = 'sample' or 'group', index = integer, shape = integer.}

\item{\code{continuousConfigSetSelectionSize(datatable_name, sample_or_group, index, size)}}{Set the size selection to a given value for the 'size' parameter. sample_or_group = 'sample' or 'group', index = integer, size = integer.}

\item{\code{continuousConfigSetStepCount(sample_or_group, datatable_parameter,
  datatable_name, step_count)}}{Set continuous configuration step count parameter to a given value. sample_or_group = 'sample' or 'group'. parameter = 'shape' or 'color' or 'size' step_count = integer value.}

\item{\code{continuousConfigSetValueAt(datatable_name, parameter_type, sample_or_group,
  index, continuous_value)}}{Set continuous configuration continuous value at a given index. sample_or_group = 'sample' or 'group'. parameter_type = 'size' or 'shape' or 'color'. }

\item{\code{continuousConfigSwitchGroupTab(datatable_name, datatable_parameter)}}{Switch continuous configuration editor window to 'group' tab. Parameter = 'shape' or 'color' or 'size'.}

\item{\code{continuousConfigSwitchSampleTab(datatable_name, datatable_parameter)}}{Switch continuous configuration editor window to 'sample' tab. Parameter = 'shape' or 'color' or 'size'.}

\item{\code{drawingConfigApply(...)}}{Apply changes to drawing configuration dialog.}

\item{\code{drawingConfigApplyAndClose(...)}}{Apply changes to drawing configuration and close dialog.}

\item{\code{drawingConfigCancel(...)}}{Cancel changes to drawing configuration dialog.}

\item{\code{drawingConfigClose(...)}}{Close drawing configuration dialog.}

\item{\code{drawingConfigOpen(...)}}{Open drawing configuration dialog.}

\item{\code{drawingConfigSelectBarplot(checked)}}{Select barplot display in drawing configuration dialog. checked = TRUE or FALSE.}

\item{\code{drawingConfigSelectDisplayAllGenes(...)}}{Select 'Display all genes' option in drawing configuration dialog.}

\item{\code{drawingConfigSelectDisplaySelectedGenes(...)}}{Select 'Display selected genes' option in drawing configuration dialog.}

\item{\code{drawingConfigSelectGlyph(glyph_num, checked)}}{Select glyph display in drawing configuration dialog. glyph_num = glyph number, checked = TRUE or FALSE.}

\item{\code{drawingConfigSelectHeatmap(checked)}}{Select heatmap display in drawing configuration dialog. checked = TRUE or FALSE.}

\item{\code{drawingConfigSelectMapStaining(checked)}}{Select map staining display in drawing configuration dialog. checked = TRUE or FALSE.}

\item{\code{file2dataString(fileName)}}{Load the content of a text file as tab-delimited string. Convert to NaviCell compatible format.}

\item{\code{findEntities(entity, bubble)}}{Find one or more entities on the map. entity = entity's name pattern (string), bubble = TRUE or FALSE.}

\item{\code{formatJson(list_param)}}{Format list of parameters to NaviCell server compatible JSON format (internal utility).}

\item{\code{formatResponse(response)}}{Format response obtained from the RCurl 'postForm' command (internal utility).}

\item{\code{geneList2string(gene_list)}}{Convert a gene list R object to a formatted string (internal utility).}

\item{\code{generateSessionId(...)}}{Generate a session ID.}

\item{\code{getBiotypeList(...)}}{Return the list of biotypes understood by NaviCell Web Service.}

\item{\code{getHugoList(...)}}{Get the list of the HUGO gene symbols for the current map (the list is stored in the object field hugo_list.}

\item{\code{getImportedDatatables(...)}}{Return the list of datatables imported in the current NaviCell session.}

\item{\code{getImportedGenes(...)}}{Return the list of genes from all the datatables imported in the current NaviCell session.}

\item{\code{getImportedSamples(...)}}{Return the list of samples from all the datatables imported in the current NaviCell session.}

\item{\code{getModuleList(...)}}{Return the module list of the current NaviCell map.}

\item{\code{glyphEditorApply(glyph_num)}}{Apply changes in the glyph editor.}

\item{\code{glyphEditorApplyAndClose(glyph_num)}}{Apply changes and close the glyph editor.}

\item{\code{glyphEditorCancel(glyph_num)}}{Cancel changes and close the glyph editor.}

\item{\code{glyphEditorClose(glyph_num)}}{Close the glyph editor.}

\item{\code{glyphEditorOpen(glyph_num)}}{Open the glyph editor. glyph_num = glyph number}

\item{\code{glyphEditorSelectColorDatatable(glyph_num, datatable_name)}}{Select datatable for glyph color in the glyph editor.}

\item{\code{glyphEditorSelectSample(glyph_num, sample_name)}}{Select sample or group in the glyph editor.}

\item{\code{glyphEditorSelectShapeDatatable(glyph_num, datatable_name)}}{Select datatable for glyph shape in the glyph editor.}

\item{\code{glyphEditorSelectSizeDatatable(glyph_num, datatable_name)}}{Select datatable for glyph size in the glyph editor.}

\item{\code{glyphEditorSetTransparency(glyph_num, value)}}{Set transparency parameter in the glyph editor. value = integer between 1 and 100.}

\item{\code{heatmapEditorApply(...)}}{Apply changes for the heatmap editor.}

\item{\code{heatmapEditorApplyAndClose(...)}}{Apply changes and close the heatmap editor.}

\item{\code{heatmapEditorCancel(...)}}{Cancel changes and close the heatmap editor.}

\item{\code{heatmapEditorClearSamples(...)}}{Clear all samples in heatmap editor.}

\item{\code{heatmapEditorClose(...)}}{Close the heatmap editor.}

\item{\code{heatmapEditorOpen(...)}}{Open the heatmap editor.}

\item{\code{heatmapEditorSelectAllGroups(...)}}{Select all groups in heatmap editor.}

\item{\code{heatmapEditorSelectAllSamples(...)}}{Select all samples in heatmap editor.}

\item{\code{heatmapEditorSelectDatatable(row_num, datatable_name)}}{Select datatable in heatmap editor. row_num = editor row number.}

\item{\code{heatmapEditorSelectSample(col_num, sample_name)}}{Select sample or group in heatmap editor. col_num = editor column number, sample_name = sample or group name.}

\item{\code{heatmapEditorSetTransparency(value)}}{Set transparency parameter in heatmap editor. value = integer between 1 and 100.}

\item{\code{importDatatable(datatable_biotype, datatable_name, mat)}}{Import a datatable (matrix) in the current map session.}

\item{\code{incMessageId(...)}}{Increase message ID counter.}

\item{\code{isImported(...)}}{Test if data table is imported (internal utility).}

\item{\code{launchBrowser(...)}}{Launch client browser and points to the default NaviCell map.}

\item{\code{listSessions(...)}}{List all NaviCell server sessions.}

\item{\code{makeData(json_string)}}{Create NaviCell server command string from a list of parameters (internal utility).}

\item{\code{mapStainingEditorApply(...)}}{Apply modifications for the map staining editor.}

\item{\code{mapStainingEditorApplyAndClose(...)}}{Apply changes and close the map staining editor.}

\item{\code{mapStainingEditorCancel(...)}}{Cancel modifications and close the map staining editor.}

\item{\code{mapStainingEditorClose(...)}}{Close the map staining editor.}

\item{\code{mapStainingEditorOpen(...)}}{Open the map staining editor.}

\item{\code{mapStainingEditorSelectDatatable(datatable_name)}}{Select a datatable for the map staining editor.}

\item{\code{mapStainingEditorSelectSample(sample_name)}}{Select a sample for the map staining editor.}

\item{\code{mapStainingEditorSetTransparency(transparency_value)}}{Set the transparency value parameter for the map staining editor (integer value between 1 and 100).}

\item{\code{matrix2string(mat)}}{Convert an R matrix object to a formatted string (internal utility).}

\item{\code{moveMapCenter(x, y)}}{Move the map center (relative). x = x coordinate (integer), y = y coordinate (integer).}

\item{\code{mydataDialogClose(...)}}{Close MyData Dialog.}

\item{\code{mydataDialogOpen(...)}}{Open MyData Dialog.}

\item{\code{mydataDialogSetDatatables(...)}}{Set Datatables tab active for MyData Dialog.}

\item{\code{mydataDialogSetGenes(...)}}{Set Genes tab active for MyData Dialog.}

\item{\code{mydataDialogSetGroups(...)}}{Set Groups tab active for MyData Dialog.}

\item{\code{mydataDialogSetModules(...)}}{Set Modules tab active for MyData Dialog.}

\item{\code{mydataDialogSetSamples(...)}}{Set Samples tab active for MyData Dialog.}

\item{\code{readDatatable(fileName)}}{Read a data file and create an R matrix. Returns a matrix object.}

\item{\code{sampleAnnotationApply(...)}}{Apply the modifications done on a sample annotation table.}

\item{\code{sampleAnnotationCancel(...)}}{Cancel changes and close sample annotation dialog.}

\item{\code{sampleAnnotationClose(...)}}{Close sample annotation dialog.}

\item{\code{sampleAnnotationOpen(...)}}{Open sample annotation dialog.}

\item{\code{sampleAnnotationSelectAnnotation(annotation_name, true_or_false)}}{Select or un-select an annotation for creating groups from a sample annotation table. true_or_false = TRUE, select, true_or_false = FALSE, un-select.}

\item{\code{selectEntity(entity)}}{Select an entity on the map. entity = entity's name (string)}

\item{\code{sendBigData(fill_cmd)}}{slice data in packets big data string and send it to server (internal utility)}

\item{\code{serverIsReady(...)}}{Test if NaviCell server is ready (internal utility).}

\item{\code{setMapCenter(location)}}{Set the relative position of the map center. location = 'MAP_CENTER' or 'MAP_EAST' or 'MAP_SOUTH' or MAP_NORTH' or 'MAP_SOUTH_WEST' or 'MAP_SOUTH_EAST' or 'MAP_NORTH_EAST'.}

\item{\code{setMapCenterAbsolute(pos_x, pos_y)}}{Set the absolute position of the map center. x = x coordinate (integer), y = y coordinate (integer).}

\item{\code{setZoom(zoom_level)}}{Set a given zoom level on associated NaviCell map in browser. zoom_level = integer value.}

\item{\code{uncheckAllEntities(...)}}{Uncheck all entities on the map.}

\item{\code{unhighlightAllEntities(...)}}{Uncheck all entities on the map.}

\item{\code{unorderedConfigApply(datatable_name, datatable_parameter)}}{Apply changes to unordered discrete configuration editor for a given type of parameter. datatable_parameter = 'shape' or 'color' or 'size'.}

\item{\code{unorderedConfigApplyAndClose(datatable_name, datatable_parameter)}}{Apply changes to unordered discrete configuration editor for a given type of parameter, and close the window. datatable_parameter = 'shape' or 'color' or 'size'.}

\item{\code{unorderedConfigCancel(datatable_name, datatable_parameter)}}{Cancel changes for unordered discrete configuration editor for a given type of parameter. datatable_parameter = 'shape' or 'color' or 'size'.}

\item{\code{unorderedConfigClose(datatable_name, datatable_parameter)}}{Open unordered discrete configuration editor for a given type of parameter. datatable_parameter = 'shape' or 'color' or 'size'.}

\item{\code{unorderedConfigOpen(datatable_name, datatable_parameter)}}{Open unordered discrete configuration editor for a given type of parameter. datatable_parameter = 'shape' or 'color' or 'size'.}

\item{\code{unorderedConfigSetAdvancedConfig(datatable_name, datatable_parameter, checked)}}{Open/close advanced configuration for unordered discrete configuration editor for a given type of parameter. datatable_parameter = 'shape' or 'color' or 'size'.}

\item{\code{unorderedConfigSetDiscreteColor(datatable_name, sample_or_group, index, color)}}{Set color value for unordered discrete configuration editor. sample_or_group = 'sample' or 'group', index = integer, color = string hex code color value, e.g. 'FF0000'.}

\item{\code{unorderedConfigSetDiscreteCondition(datatable_name, datatable_parameter,
  sample_or_group, index, condition)}}{Set condition value for unordered discrete configuration editor. datatable_parameter = 'size' or 'shape' or 'color'. sample_or_group = 'sample' or 'group', index = integer, condition = integer.}

\item{\code{unorderedConfigSetDiscreteShape(datatable_name, sample_or_group, index, shape)}}{Set shape value for unordered discrete configuration editor. sample_or_group = 'sample' or 'group', index = integer, shape = integer.}

\item{\code{unorderedConfigSetDiscreteSize(datatable_name, sample_or_group, index, size)}}{Set size value for unordered discrete configuration editor. sample_or_group = 'sample' or 'group', index = integer, size = integer.}

\item{\code{unorderedConfigSetDiscreteValue(datatable_name, datatable_parameter,
  sample_or_group, index, value)}}{Set discrete value for unordered discrete configuration editor for a given
type of parameter. datatable_parameter = 'shape' or
'color' or 'size', sample_or_group = 'sample' or 'group', index = integer,
value = double.}

\item{\code{unorderedConfigSwitchGroupTab(datatable_name, datatable_parameter)}}{Switch to group tab for unordered discrete configuration editor. datatable_parameter = 'size' or 'shape' or 'color'.}

\item{\code{unorderedConfigSwitchSampleTab(datatable_name, datatable_parameter)}}{Switch to sample tab for unordered discrete configuration editor. datatable_parameter = 'size' or 'shape' or 'color'.}

\item{\code{waitForImported(...)}}{Wait until data is imported (internal utility).}

\item{\code{waitForReady(...)}}{Wait until NaviCell server is ready (internal utility).}
}}
\examples{
\dontrun{
	### Opens a communication with web service, build does not finish if example is tested
	file<-system.file("extdata", "script.R", package = "RNaviCell")
	source("file")
	}
}

