% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RankNormal.R
\name{BAT}
\alias{BAT}
\title{Basic Association Test}
\usage{
BAT(y, G, X, S, calcP = T, parallel = F, check = T)
}
\arguments{
\item{y}{Numeric phenotype vector.}

\item{G}{Numeric snp by obs genotype matrix.}

\item{X}{Numeric obs by feature covariate matrix.}

\item{S}{Numeric obs by feature structure matrix.}

\item{calcP}{Logical indicating that p values should be calculated.}

\item{parallel}{Logical indicating whether to run in parallel. Must register
parallel backend first.}

\item{check}{Logical indicating whether to check the input.}
}
\value{
A numeric matrix of score statistics, one for each locus (row) in \code{G},
  assessing the null hypothesis that genotype is unrelated to the outcome. If
  \code{p=T}, a p-value is additionally calculated for each locus.
}
\description{
Tests the association between genotype and the untransformed phenotype, 
adjusting for covariates and population structure.
}
\examples{
# BAT against normal phenotype
p = RNOmni::BAT(y=RNOmni::Y[,1],G=RNOmni::G[1:10,],X=RNOmni::X,S=RNOmni::S);
}
