% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_guide.R
\name{RNAseqNetUsersGuide}
\alias{RNAseqNetUsersGuide}
\title{View RNAseqNet User's Guide}
\usage{
RNAseqNetUsersGuide(html = TRUE, view = html)
}
\arguments{
\item{html}{logical. Should the document returned by the function be the
compiled PDF or the Rmd source. Default to \code{TRUE}}

\item{view}{logical. Should the document be opened using the default HTML
viewer? Default to \code{html}. It has no effect if \code{html = FALSE}}
}
\value{
Character string giving the file location. If \code{html = TRUE} and
\code{view = TRUE}, the HTML document reader is started and the User's Guide
is opened in it.
}
\description{
Find the location of the RNAseqNet User's Guide and optionnaly
opens it
}
\details{
The function \code{vignette("RNAseqNet")} will find the short
RNAseqNet vignette that describes how to obtain the RNAseqNet User's Guide.
The User's Guide is not itself a true vignette because it is not
automatically generated during the package build process. However, the
location of the Rmarkdown source is returned by the function if
\code{html = FALSE}.
If the operating system is not Windows, then the HTML viewer used is that
given by \code{Sys.getenv("R_BROWSER")}. The HTML viewer can be changed using
 \code{Sys.setenv(R_BROWSER = )}.
}
\examples{
RNAseqNetUsersGuide(view = FALSE)
RNAseqNetUsersGuide(html = FALSE)
\dontrun{RNAseqNetUsersGuide()}
}
\author{
{Alyssa Imbert, \email{alyssa.imbert@inra.fr}

Nathalie Villa-Vialaneix, \email{nathalie.villa-vialaneix@inra.fr}}
}
