% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MIXTCOMP_getter.R
\name{getPartition}
\alias{getPartition}
\title{Get the estimated class from MixtComp object}
\usage{
getPartition(outMixtComp, empiric = FALSE)
}
\arguments{
\item{outMixtComp}{object of class \emph{MixtCompLearn} or \emph{MixtComp} obtained using \code{mixtCompLearn} or
\code{mixtCompPredict} functions from \code{RMixtComp} package or \code{rmcMultiRun} from \code{RMixtCompIO} package.}

\item{empiric}{if TRUE, use the partition obtained at the end of the gibbs algorithm. If FALSE, use the partition
obtained with the observed probabilities.}
}
\value{
a vector containing the estimated class for each individual.
}
\description{
Get the estimated class from MixtComp object
}
\examples{
require(RMixtCompIO) # for learning a mixture model
dataLearn <- list(
  var1 = as.character(c(rnorm(50, -2, 0.8), rnorm(50, 2, 0.8))),
  var2 = as.character(c(rnorm(50, 2), rpois(50, 8)))
)

model <- list(
  var1 = list(type = "Gaussian", paramStr = ""),
  var2 = list(type = "Poisson", paramStr = "")
)

algo <- list(
  nClass = 2,
  nInd = 100,
  nbBurnInIter = 100,
  nbIter = 100,
  nbGibbsBurnInIter = 100,
  nbGibbsIter = 100,
  nInitPerClass = 3,
  nSemTry = 20,
  confidenceLevel = 0.95,
  ratioStableCriterion = 0.95,
  nStableCriterion = 10,
  mode = "learn"
)

resLearn <- rmcMultiRun(algo, dataLearn, model, nRun = 3)

# get class
estimatedClass <- getPartition(resLearn)

}
\seealso{
Other getter: 
\code{\link{getBIC}()},
\code{\link{getCompletedData}()},
\code{\link{getEmpiricTik}()},
\code{\link{getMixtureDensity}()},
\code{\link{getParam}()},
\code{\link{getType}()}
}
\author{
Quentin Grimonprez
}
\concept{getter}
