% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MIXTCOMP_misc.R
\name{createAlgo}
\alias{createAlgo}
\title{Create algo object}
\usage{
createAlgo(
  nbBurnInIter = 50,
  nbIter = 50,
  nbGibbsBurnInIter = 50,
  nbGibbsIter = 50,
  nInitPerClass = 50,
  nSemTry = 20,
  confidenceLevel = 0.95,
  ratioStableCriterion = 0.99,
  nStableCriterion = 20
)
}
\arguments{
\item{nbBurnInIter}{Number of iterations of the burn-in part of the SEM algorithm.}

\item{nbIter}{Number of iterations of the SEM algorithm.}

\item{nbGibbsBurnInIter}{Number of iterations of the burn-in part of the Gibbs algorithm.}

\item{nbGibbsIter}{Number of iterations of the Gibbs algorithm.}

\item{nInitPerClass}{Number of individuals used to initialize each cluster.}

\item{nSemTry}{Number of try of the algorithm for avoiding an error.}

\item{confidenceLevel}{confidence level for confidence bounds for parameter estimation}

\item{ratioStableCriterion}{stability partition required to stop earlier the SEM}

\item{nStableCriterion}{number of iterations of partition stability to stop earlier the SEM}
}
\value{
a list with the parameters values
}
\description{
create an algo object required by \code{mixtCompLearn} and \code{mixtCompPredict} from \code{RMixtComp}.
}
\examples{
# default values
algo <- createAlgo()

# change some values
algo <- createAlgo(nbIter = 200)

}
\author{
Quentin Grimonprez
}
