% Generated by roxygen2 (4.0.2): do not edit by hand
\name{adjust.value}
\alias{adjust.chat}
\alias{adjust.value}
\title{Adjust over-dispersion scale or a result value such as effective sample size}
\usage{
adjust.value(field="n",value,model.list)
       adjust.chat(chat=1,model.list)
}
\arguments{
\item{field}{Character string containing name of the field; either
\code{chat} or a field in \code{model$results} such as \code{n} for sample
size used in AICc or QAICc}

\item{value}{new value for field}

\item{model.list}{marklist created by the function
\code{\link{collect.models}} which has each model object and a
\code{model.table} at the end. For the entire collection of models each
\code{chat} is adjusted. If the argument type is specified the collected
models are limited to mark analyses with that specific type of model ("CJS")}

\item{chat}{Over-dispersion scale}
}
\value{
model.list with all models given the new chat value and model.table
adjusted for chat values
}
\description{
Adjust value of over-dispersion constant or another result value for a
collection of models which modifies model selection criterion and estimated
standard errors.
}
\details{
The value of \code{chat} is stored with the model object except when there
is no over-dispersion (\code{chat}=1). This function assigns a new value of
\code{chat} for the collection of models specified by \code{model.list}
and/or \code{type}.  The value of \code{chat} is used by
\code{\link{model.table}} for model selection in computing QAICc unless
\code{chat=1}.  It is also used in \code{\link{summary.mark}},
\code{\link{get.real}} and \code{\link{compute.real}} to adjust standard
errors and confidence intervals. Note that the standard errors and
confidence intervals in \code{results$beta},\code{results$beta.vcv}
\code{results$real}, \code{results$derived} and \code{results$derived.vcv}
are not modified and always assume \code{chat=1}.

It can also be used to modify a field in \code{model$results} such as
\code{n} which is ESS (effective sample size) from MARK output that is used
in AICc/QAICc calculations.
}
\note{
See note in \code{\link{collect.models}}
}
\examples{
#
# The following are examples only to demonstrate selecting different
# model sets for adjusting chat and showing model selection table.
# It is not a realistic analysis.
#
\donttest{
data(dipper)
mod1=mark(dipper)
mod2=mark(dipper,model.parameters=list(Phi=list(formula=~time)))
mod3=mark(dipper,model="POPAN",initial=1)
cjs.results=collect.models(type="CJS")
cjs.results  # show model selection results for "CJS" models
POPAN.results=collect.models(type="POPAN")
POPAN.results # show model selection results for "POPAN" model
# adjust chat for all models to 2
cjs.results=adjust.chat(2,cjs.results)
cjs.results
# adjust chat for all models to 2
POPAN.results=adjust.chat(2,POPAN.results)
POPAN.results
}
}
\author{
Jeff Laake
}
\seealso{
\code{\link{model.table}}, \code{\link{summary.mark}},
\code{\link{get.real}} ,\code{\link{compute.real}}
}
\keyword{utility}

