/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.BatchConverter;
import weka.core.converters.IncrementalConverter;
import weka.core.converters.URLSourcedLoader;

public class ArffLoader
extends AbstractFileLoader
implements BatchConverter,
IncrementalConverter,
URLSourcedLoader {
    static final long serialVersionUID = 2726929550544048587L;
    public static String FILE_EXTENSION = Instances.FILE_EXTENSION;
    public static String FILE_EXTENSION_COMPRESSED = FILE_EXTENSION + ".gz";
    protected String m_URL = "http://";
    private transient Reader m_sourceReader = null;

    public String globalInfo() {
        return "Reads a source that is in arff (attribute relation file format) format. ";
    }

    public String getFileExtension() {
        return FILE_EXTENSION;
    }

    public String[] getFileExtensions() {
        return new String[]{FILE_EXTENSION, FILE_EXTENSION_COMPRESSED};
    }

    public String getFileDescription() {
        return "Arff data files";
    }

    public void reset() throws IOException {
        this.m_structure = null;
        this.setRetrieval(0);
        if (this.m_File != null && new File(this.m_File).isFile()) {
            this.setFile(new File(this.m_File));
        } else if (this.m_URL != null & !this.m_URL.equals("http://")) {
            this.setURL(this.m_URL);
        }
    }

    public void setSource(URL uRL) throws IOException {
        this.m_structure = null;
        this.setRetrieval(0);
        this.setSource(uRL.openStream());
        this.m_URL = uRL.toString();
    }

    public File retrieveFile() {
        return new File(this.m_File);
    }

    public void setFile(File file) throws IOException {
        this.m_File = file.getAbsolutePath();
        this.setSource(file);
    }

    public void setSource(File file) throws IOException {
        this.m_structure = null;
        this.setRetrieval(0);
        if (file == null) {
            throw new IOException("Source file object is null!");
        }
        try {
            if (file.getName().endsWith(FILE_EXTENSION_COMPRESSED)) {
                this.setSource(new GZIPInputStream(new FileInputStream(file)));
            } else {
                this.setSource(new FileInputStream(file));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IOException("File not found");
        }
        this.m_sourceFile = file;
        this.m_File = file.getAbsolutePath();
    }

    public void setURL(String string) throws IOException {
        this.m_URL = string;
        this.setSource(new URL(string));
    }

    public String retrieveURL() {
        return this.m_URL;
    }

    public void setSource(InputStream inputStream) throws IOException {
        this.m_File = new File(System.getProperty("user.dir")).getAbsolutePath();
        this.m_URL = "http://";
        this.m_sourceReader = new BufferedReader(new InputStreamReader(inputStream));
    }

    public Instances getStructure() throws IOException {
        if (this.m_sourceReader == null) {
            throw new IOException("No source has been specified");
        }
        if (this.m_structure == null) {
            try {
                this.m_structure = new Instances(this.m_sourceReader, 1);
            }
            catch (Exception exception) {
                throw new IOException("Unable to determine structure as arff (Reason: " + exception.toString() + ").");
            }
        }
        return new Instances(this.m_structure, 0);
    }

    public Instances getDataSet() throws IOException {
        if (this.m_sourceReader == null) {
            throw new IOException("No source has been specified");
        }
        if (this.getRetrieval() == 2) {
            throw new IOException("Cannot mix getting Instances in both incremental and batch modes");
        }
        this.setRetrieval(1);
        if (this.m_structure == null) {
            this.getStructure();
        }
        while (this.m_structure.readInstance(this.m_sourceReader)) {
        }
        Instances instances = new Instances(this.m_structure);
        return instances;
    }

    public Instance getNextInstance() throws IOException {
        if (this.m_structure == null) {
            this.getStructure();
        }
        if (this.getRetrieval() == 1) {
            throw new IOException("Cannot mix getting Instances in both incremental and batch modes");
        }
        this.setRetrieval(2);
        if (!this.m_structure.readInstance(this.m_sourceReader)) {
            return null;
        }
        Instance instance = this.m_structure.instance(0);
        this.m_structure.delete(0);
        if (instance == null) {
            try {
                this.reset();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return instance;
    }

    public static void main(String[] stringArray) {
        ArffLoader.runFileLoader(new ArffLoader(), stringArray);
    }
}

