/*
 * Decompiled with CFR 0.152.
 */
package jena;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.Util;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class schemagen_orig {
    public static void main(String[] args) {
        if (args.length < 4 || args.length > 5) {
            schemagen_orig.usage();
            System.exit(-1);
        }
        String name = args[0];
        String schemaURIRef = args[1];
        String input = args[2];
        String output = args[3];
        String lang = "RDF/XML";
        if (args.length > 4) {
            lang = args[4];
        }
        try {
            Model schema = ModelFactory.createDefaultModel();
            schemagen_orig.read(schema, input, lang);
            PrintStream out = null;
            out = output.equals("-") ? System.out : new PrintStream(new FileOutputStream(output));
            schemagen_orig.renderVocabularyClass(name, schemaURIRef, schema, out);
        }
        catch (Exception e) {
            System.err.println("Unhandled exception:");
            System.err.println("    " + e.toString());
            System.exit(-1);
        }
    }

    protected static void usage() {
        System.err.println("usage:");
        System.err.println("    java jena.schemagen_orig name schemaURIRef input output [lang]");
        System.err.println();
        System.err.println("    name is the name of the vocabulary");
        System.err.println("         It may be simple, e.g. RDF, or it may be fully qualified");
        System.err.println("    input can be URL's or filenames");
        System.err.println("    lang can take values");
        System.err.println("      RDF/XML");
        System.err.println("      N-TRIPLE");
        System.err.println("    lang defaults to RDF/XML");
        System.err.println();
    }

    protected static void read(Model model, String in, String lang) throws FileNotFoundException {
        try {
            new URL(in);
            model.read(in, lang);
        }
        catch (MalformedURLException e) {
            model.read(new FileReader(in), "", lang);
        }
    }

    protected static void renderVocabularyClass(String name, String uriRef, Model schema, PrintStream out) {
        Set classNames = schemagen_orig.listNames(uriRef, schema, RDFS.Class);
        Set propertyNames = schemagen_orig.listNames(uriRef, schema, RDF.Property);
        schemagen_orig.renderPreamble(name, uriRef, out);
        schemagen_orig.renderDeclarations(classNames, "Resource", out);
        schemagen_orig.renderDeclarations(propertyNames, "Property", out);
        schemagen_orig.renderInitializer(classNames, propertyNames, out);
        schemagen_orig.renderPostamble(out);
    }

    protected static Set listNames(String uriRef, Model schema, Resource type) {
        HashSet<String> result = new HashSet<String>();
        StmtIterator iter = schema.listStatements(null, RDF.type, type);
        while (iter.hasNext()) {
            String s;
            Resource r = iter.nextStatement().getSubject();
            if (r.isAnon() || !(s = r.getURI()).startsWith(uriRef)) continue;
            result.add(s.substring(uriRef.length()));
        }
        return result;
    }

    protected static void renderDeclarations(Set names, String type, PrintStream out) {
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            String jname = schemagen_orig.makeJavaLegalId(name);
            out.println("           static String n" + jname + " = \"" + name + "\";");
            out.println("    public static " + type + " " + jname + ";");
        }
    }

    protected static void renderInitializer(Set classNames, Set propertyNames, PrintStream out) {
        out.println();
        out.println("    static {");
        out.println("        try {");
        schemagen_orig.renderTypedInitializer(classNames, "Resource", out);
        schemagen_orig.renderTypedInitializer(propertyNames, "Property", out);
        out.println("        } catch (Exception e) {");
        out.println("            ErrorHelper.logInternalError(\"RDF\", 1, e);");
        out.println("        }");
        out.println("    }");
    }

    protected static void renderTypedInitializer(Set names, String type, PrintStream out) {
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            String jname = schemagen_orig.makeJavaLegalId((String)iter.next());
            out.println("            " + jname + " = ResourceFactory.create" + type + "(uri + n" + jname + ");");
        }
    }

    protected static void renderPreamble(String name, String uriRef, PrintStream out) {
        String packageName;
        if (name.indexOf(46) == -1) {
            packageName = "com.hp.hpl.jena.vocabulary";
        } else {
            packageName = name.substring(0, name.lastIndexOf(46));
            name = name.substring(name.lastIndexOf(46) + 1);
        }
        out.println("/* Vocabulary Class generated by Jena vocabulary generator");
        out.println(" *");
        out.println(" * On: " + new Date().toString());
        out.println(" * Version $Id$");
        out.println(" */");
        out.println("package " + packageName + ";");
        out.println();
        out.println("import com.hp.hpl.jena.rdf.model.impl.ErrorHelper;");
        out.println("import com.hp.hpl.jena.rdf.model.Model;");
        out.println("import com.hp.hpl.jena.rdf.model.Resource;");
        out.println("import com.hp.hpl.jena.rdf.model.ResourceFactory;");
        out.println("import com.hp.hpl.jena.rdf.model.Property;");
        out.println("import com.hp.hpl.jena.rdf.model.RDFException;");
        out.println();
        out.println("/** " + name + " vocabulary class for namespace " + uriRef);
        out.println(" */");
        out.println("public class " + name + " {");
        out.println();
        out.println("    protected static final String uri =\"" + uriRef + "\";");
        out.println();
        out.println("    /** returns the URI for this schema");
        out.println("     * @return the URI for this schema");
        out.println("     */");
        out.println("    public static String getURI() {");
        out.println("          return uri;");
        out.println("    }");
    }

    protected static void renderPostamble(PrintStream out) {
        out.println("}");
    }

    protected static String makeJavaLegalId(String name) {
        name = Util.replace(name, "-", "_");
        return Util.replace(name, ".", "_");
    }
}

